/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.CallStack;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.text.Utf8String;

public abstract class Routable {
    private final CallStack callStack = new CallStack();
    private final Trace trace = new Trace();
    private Object context = null;

    public void discard() {
        this.context = null;
        this.callStack.clear();
        this.trace.clear();
    }

    public void swapState(Routable rhs) {
        Object context = this.context;
        this.context = rhs.context;
        rhs.context = context;
        this.callStack.swap(rhs.getCallStack());
        this.trace.swap(rhs.getTrace());
    }

    public void pushHandler(ReplyHandler handler) {
        this.callStack.push(handler, this.context);
    }

    public ReplyHandler popHandler() {
        return this.callStack.pop(this);
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public abstract Utf8String getProtocol();

    public abstract int getType();
}

