/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class Sequencer
implements MessageHandler,
ReplyHandler {
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final MessageHandler sender;
    private final Map<Long, Queue<Message>> seqMap = new HashMap<Long, Queue<Message>>();

    public Sequencer(MessageHandler sender) {
        this.sender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        if (!this.destroyed.getAndSet(true)) {
            Sequencer sequencer = this;
            synchronized (sequencer) {
                for (Queue<Message> queue : this.seqMap.values()) {
                    if (queue == null) continue;
                    for (Message msg : queue) {
                        msg.discard();
                    }
                }
                this.seqMap.clear();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean filter(Message msg) {
        long seqId = msg.getSequenceId();
        msg.setContext(seqId);
        Sequencer sequencer = this;
        synchronized (sequencer) {
            if (this.seqMap.containsKey(seqId)) {
                Queue<Message> queue = this.seqMap.get(seqId);
                if (queue == null) {
                    queue = new LinkedList<Message>();
                    this.seqMap.put(seqId, queue);
                }
                if (msg.getTrace().shouldTrace(6)) {
                    msg.getTrace().trace(6, "Sequencer queued message with sequence id '" + seqId + "'.");
                }
                queue.add(msg);
                return false;
            }
            this.seqMap.put(seqId, null);
        }
        return true;
    }

    private void sequencedSend(Message msg) {
        if (msg.getTrace().shouldTrace(6)) {
            msg.getTrace().trace(6, "Sequencer sending message with sequence id '" + msg.getContext() + "'.");
        }
        msg.pushHandler(this);
        this.sender.handleMessage(msg);
    }

    @Override
    public void handleMessage(Message msg) {
        if (this.destroyed.get()) {
            msg.discard();
            return;
        }
        if (msg.hasSequenceId()) {
            if (this.filter(msg)) {
                this.sequencedSend(msg);
            }
        } else {
            this.sender.handleMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(Reply reply) {
        if (this.destroyed.get()) {
            reply.discard();
            return;
        }
        long seqId = (Long)reply.getContext();
        if (reply.getTrace().shouldTrace(6)) {
            reply.getTrace().trace(6, "Sequencer received reply with sequence id '" + seqId + "'.");
        }
        Message msg = null;
        Sequencer sequencer = this;
        synchronized (sequencer) {
            Queue<Message> queue = this.seqMap.get(seqId);
            if (queue == null || queue.isEmpty()) {
                this.seqMap.remove(seqId);
            } else {
                msg = queue.remove();
            }
        }
        if (msg != null) {
            this.sequencedSend(msg);
        }
        ReplyHandler handler = reply.popHandler();
        handler.handleReply(reply);
    }
}

