/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.PolicyDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingNode;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoutingContext {
    private final RoutingNode node;
    private final int directive;
    private final Set<Integer> consumableErrors = new HashSet<Integer>();
    private boolean selectOnRetry = true;
    private Object context = null;

    RoutingContext(RoutingNode node, int directive) {
        this.node = node;
        this.directive = directive;
    }

    public String toString() {
        return "node : " + String.valueOf(this.node) + ", directive: " + this.directive + ", errors: " + String.valueOf(this.consumableErrors) + ", selectOnRetry: " + this.selectOnRetry + " context: " + String.valueOf(this.context);
    }

    public boolean hasRecipients() {
        return !this.node.getRecipients().isEmpty();
    }

    public int getNumRecipients() {
        return this.node.getRecipients().size();
    }

    public Route getRecipient(int idx) {
        return this.node.getRecipients().get(idx);
    }

    public List<Route> getAllRecipients() {
        return Collections.unmodifiableList(this.node.getRecipients());
    }

    public List<Route> getMatchedRecipients() {
        ArrayList<Route> ret = new ArrayList<Route>();
        HashSet<String> done = new HashSet<String>();
        Hop hop = this.getHop();
        for (Route route : this.node.getRecipients()) {
            HopDirective dir;
            String key;
            if (!route.hasHops() || !hop.matches(route.getHop(0)) || done.contains(key = (dir = route.getHop(0).getDirective(this.directive)).toString())) continue;
            ret.add(new Route(route).setHop(0, new Hop(hop).setDirective(this.directive, dir)));
            done.add(key);
        }
        return ret;
    }

    public boolean getSelectOnRetry() {
        return this.selectOnRetry;
    }

    public RoutingContext setSelectOnRetry(boolean selectOnRetry) {
        this.selectOnRetry = selectOnRetry;
        return this;
    }

    public Route getRoute() {
        return this.node.getRoute();
    }

    public Hop getHop() {
        return this.node.getRoute().getHop(0);
    }

    public int getDirectiveIndex() {
        return this.directive;
    }

    public PolicyDirective getDirective() {
        return (PolicyDirective)this.getHop().getDirective(this.directive);
    }

    public String getHopPrefix() {
        return this.getHop().getPrefix(this.directive);
    }

    public String getHopSuffix() {
        return this.getHop().getSuffix(this.directive);
    }

    public Object getContext() {
        return this.context;
    }

    public RoutingContext setContext(Object context) {
        this.context = context;
        return this;
    }

    public Message getMessage() {
        return this.node.getMessage();
    }

    public void trace(int level, String note) {
        this.node.getTrace().trace(level, note);
    }

    public boolean shouldTrace(int level) {
        return this.node.getTrace().shouldTrace(level);
    }

    public boolean hasReply() {
        return this.node.hasReply();
    }

    public Reply getReply() {
        return this.node.getReply();
    }

    public RoutingContext setReply(Reply reply) {
        this.node.setReply(reply);
        return this;
    }

    public RoutingContext setError(int code, String msg) {
        this.node.setError(code, msg);
        return this;
    }

    public RoutingContext setError(Error err) {
        this.node.setError(err);
        return this;
    }

    public MessageBus getMessageBus() {
        return this.node.getMessageBus();
    }

    public boolean hasChildren() {
        return !this.node.getChildren().isEmpty();
    }

    public int getNumChildren() {
        return this.node.getChildren().size();
    }

    public RoutingNodeIterator getChildIterator() {
        return new RoutingNodeIterator(this.node.getChildren());
    }

    public void addChild(Route route) {
        this.node.addChild(route);
    }

    public void addChildren(List<Route> routes) {
        if (routes != null) {
            for (Route route : routes) {
                this.addChild(route);
            }
        }
    }

    public IMirror getMirror() {
        return this.node.getNetwork().getMirror();
    }

    public void addConsumableError(int errorCode) {
        this.consumableErrors.add(errorCode);
    }

    public boolean isConsumableError(int errorCode) {
        return this.consumableErrors.contains(errorCode);
    }
}

