/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import java.util.ArrayDeque;
import java.util.Deque;

public class CallStack {
    private Deque<StackFrame> stack = new ArrayDeque<StackFrame>();

    public void push(ReplyHandler handler, Object context) {
        this.stack.push(new StackFrame(handler, context));
    }

    public ReplyHandler pop(Routable routable) {
        StackFrame frame = this.stack.pop();
        routable.setContext(frame.context);
        return frame.handler;
    }

    public void swap(CallStack other) {
        Deque<StackFrame> tmp = this.stack;
        this.stack = other.stack;
        other.stack = tmp;
    }

    public void clear() {
        this.stack.clear();
    }

    public int size() {
        return this.stack.size();
    }

    private static class StackFrame {
        private final ReplyHandler handler;
        private final Object context;

        StackFrame(ReplyHandler handler, Object context) {
            this.handler = handler;
            this.context = context;
        }
    }
}

