/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.HopSpec;
import java.util.ArrayList;
import java.util.List;

public class HopBlueprint {
    private final List<HopDirective> selector = new ArrayList<HopDirective>();
    private final List<Hop> recipients = new ArrayList<Hop>();
    private boolean ignoreResult = false;

    HopBlueprint(HopSpec spec) {
        Hop hop = Hop.parse(spec.getSelector());
        for (int i = 0; i < hop.getNumDirectives(); ++i) {
            this.selector.add(hop.getDirective(i));
        }
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; i < spec.getNumRecipients(); ++i) {
            lst.add(spec.getRecipient(i));
        }
        for (String recipient : lst) {
            this.recipients.add(Hop.parse(recipient));
        }
        this.ignoreResult = spec.getIgnoreResult();
    }

    public Hop create() {
        return new Hop(this.selector, this.ignoreResult);
    }

    public boolean hasDirectives() {
        return !this.selector.isEmpty();
    }

    public int getNumDirectives() {
        return this.selector.size();
    }

    public HopDirective getDirective(int i) {
        return this.selector.get(i);
    }

    public boolean hasRecipients() {
        return !this.recipients.isEmpty();
    }

    public int getNumRecipients() {
        return this.recipients.size();
    }

    public Hop getRecipient(int i) {
        return this.recipients.get(i);
    }

    public boolean getIgnoreResult() {
        return this.ignoreResult;
    }

    public HopBlueprint setIgnoreResult(boolean ignoreResult) {
        this.ignoreResult = ignoreResult;
        return this;
    }

    public String toString() {
        int i;
        StringBuilder ret = new StringBuilder("HopBlueprint(selector = { ");
        for (i = 0; i < this.selector.size(); ++i) {
            ret.append("'").append(this.selector.get(i)).append("'");
            if (i >= this.selector.size() - 1) continue;
            ret.append(", ");
        }
        ret.append(" }, recipients = { ");
        for (i = 0; i < this.recipients.size(); ++i) {
            ret.append("'").append(this.recipients.get(i)).append("'");
            if (i >= this.recipients.size() - 1) continue;
            ret.append(", ");
        }
        ret.append(" }, ignoreResult = ").append(this.ignoreResult).append(")");
        return ret.toString();
    }
}

