/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingNode;
import java.util.Iterator;
import java.util.List;

public class RoutingNodeIterator {
    private Iterator<RoutingNode> it;
    private RoutingNode entry;

    public RoutingNodeIterator(List<RoutingNode> children) {
        this.it = children.iterator();
        this.next();
    }

    public RoutingNodeIterator next() {
        this.entry = this.it.hasNext() ? this.it.next() : null;
        return this;
    }

    public RoutingNodeIterator skip(int num) {
        for (int i = 0; i < num && this.isValid(); ++i) {
            this.next();
        }
        return this;
    }

    public boolean isValid() {
        return this.entry != null;
    }

    public Route getRoute() {
        return this.entry.getRoute();
    }

    public boolean hasReply() {
        return this.entry.hasReply();
    }

    public Reply removeReply() {
        Reply ret = this.entry.getReply();
        ret.getTrace().setLevel(this.entry.getTrace().getLevel());
        ret.getTrace().swap(this.entry.getTrace());
        this.entry.setReply(null);
        return ret;
    }

    public Reply getReplyRef() {
        return this.entry.getReply();
    }
}

