/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class MessagebusConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "04a33fc5c97314d4c98f3d743fbd25c4";
    public static final String CONFIG_DEF_NAME = "messagebus";
    public static final String CONFIG_DEF_NAMESPACE = "messagebus";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=messagebus", "routingtable[].protocol string", "routingtable[].hop[].name string", "routingtable[].hop[].selector string", "routingtable[].hop[].recipient[] string", "routingtable[].hop[].ignoreresult bool default=false", "routingtable[].route[].name string", "routingtable[].route[].hop[] string"};
    private final InnerNodeVector<Routingtable> routingtable;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return "messagebus";
    }

    public static String getDefNamespace() {
        return "messagebus";
    }

    public MessagebusConfig(Builder builder) {
        this(builder, true);
    }

    private MessagebusConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for messagebus must be initialized: " + builder.__uninitialized);
        }
        this.routingtable = Routingtable.createVector(builder.routingtable);
    }

    public List<Routingtable> routingtable() {
        return this.routingtable;
    }

    public Routingtable routingtable(int i) {
        return (Routingtable)((Object)this.routingtable.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(MessagebusConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("messagebus");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Routingtable.Builder> routingtable = new ArrayList<Routingtable.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(MessagebusConfig config) {
            for (Routingtable r : config.routingtable()) {
                this.routingtable(new Routingtable.Builder(r));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.routingtable.isEmpty()) {
                this.routingtable.addAll(__superior.routingtable);
            }
            return this;
        }

        public Builder routingtable(Routingtable.Builder __builder) {
            this.routingtable.add(__builder);
            return this;
        }

        public Builder routingtable(Consumer<Routingtable.Builder> __func) {
            Routingtable.Builder __inner = new Routingtable.Builder();
            __func.accept(__inner);
            this.routingtable.add(__inner);
            return this;
        }

        public Builder routingtable(List<Routingtable.Builder> __builders) {
            this.routingtable = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return MessagebusConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return "messagebus";
        }

        public final String getDefNamespace() {
            return "messagebus";
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public MessagebusConfig build() {
            return new MessagebusConfig(this);
        }
    }

    public static final class Routingtable
    extends InnerNode {
        private final StringNode protocol;
        private final InnerNodeVector<Hop> hop;
        private final InnerNodeVector<Route> route;

        public Routingtable(Builder builder) {
            this(builder, true);
        }

        private Routingtable(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for messagebus.routingtable[] must be initialized: " + builder.__uninitialized);
            }
            this.protocol = builder.protocol == null ? new StringNode() : new StringNode(builder.protocol);
            this.hop = Hop.createVector(builder.hop);
            this.route = Route.createVector(builder.route);
        }

        public String protocol() {
            return this.protocol.value();
        }

        public List<Hop> hop() {
            return this.hop;
        }

        public Hop hop(int i) {
            return (Hop)((Object)this.hop.get(i));
        }

        public List<Route> route() {
            return this.route;
        }

        public Route route(int i) {
            return (Route)((Object)this.route.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Routingtable newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("routingtable");
            return changes;
        }

        private static InnerNodeVector<Routingtable> createVector(List<Builder> builders) {
            ArrayList<Routingtable> elems = new ArrayList<Routingtable>();
            for (Builder b : builders) {
                elems.add(new Routingtable(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("protocol"));
            private String protocol = null;
            public List<Hop.Builder> hop = new ArrayList<Hop.Builder>();
            public List<Route.Builder> route = new ArrayList<Route.Builder>();

            public Builder() {
            }

            public Builder(Routingtable config) {
                this.protocol(config.protocol());
                for (Hop h : config.hop()) {
                    this.hop(new Hop.Builder(h));
                }
                for (Route r : config.route()) {
                    this.route(new Route.Builder(r));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.protocol != null) {
                    this.protocol(__superior.protocol);
                }
                if (!__superior.hop.isEmpty()) {
                    this.hop.addAll(__superior.hop);
                }
                if (!__superior.route.isEmpty()) {
                    this.route.addAll(__superior.route);
                }
                return this;
            }

            public Builder protocol(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.protocol = __value;
                this.__uninitialized.remove("protocol");
                return this;
            }

            public Builder hop(Hop.Builder __builder) {
                this.hop.add(__builder);
                return this;
            }

            public Builder hop(Consumer<Hop.Builder> __func) {
                Hop.Builder __inner = new Hop.Builder();
                __func.accept(__inner);
                this.hop.add(__inner);
                return this;
            }

            public Builder hop(List<Hop.Builder> __builders) {
                this.hop = __builders;
                return this;
            }

            public Builder route(Route.Builder __builder) {
                this.route.add(__builder);
                return this;
            }

            public Builder route(Consumer<Route.Builder> __func) {
                Route.Builder __inner = new Route.Builder();
                __func.accept(__inner);
                this.route.add(__inner);
                return this;
            }

            public Builder route(List<Route.Builder> __builders) {
                this.route = __builders;
                return this;
            }

            public Routingtable build() {
                return new Routingtable(this);
            }
        }

        public static final class Hop
        extends InnerNode {
            private final StringNode name;
            private final StringNode selector;
            private final LeafNodeVector<String, StringNode> recipient;
            private final BooleanNode ignoreresult;

            public Hop(Builder builder) {
                this(builder, true);
            }

            private Hop(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for messagebus.routingtable[].hop[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.selector = builder.selector == null ? new StringNode() : new StringNode(builder.selector);
                this.recipient = new LeafNodeVector(builder.recipient, (LeafNode)new StringNode());
                this.ignoreresult = builder.ignoreresult == null ? new BooleanNode(false) : new BooleanNode(builder.ignoreresult.booleanValue());
            }

            public String name() {
                return this.name.value();
            }

            public String selector() {
                return this.selector.value();
            }

            public List<String> recipient() {
                return this.recipient.asList();
            }

            public String recipient(int i) {
                return ((StringNode)this.recipient.get(i)).value();
            }

            public boolean ignoreresult() {
                return this.ignoreresult.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Hop newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("hop");
                return changes;
            }

            private static InnerNodeVector<Hop> createVector(List<Builder> builders) {
                ArrayList<Hop> elems = new ArrayList<Hop>();
                for (Builder b : builders) {
                    elems.add(new Hop(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "selector"));
                private String name = null;
                private String selector = null;
                public List<String> recipient = new ArrayList<String>();
                private Boolean ignoreresult = null;

                public Builder() {
                }

                public Builder(Hop config) {
                    this.name(config.name());
                    this.selector(config.selector());
                    this.recipient(config.recipient());
                    this.ignoreresult(config.ignoreresult());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.selector != null) {
                        this.selector(__superior.selector);
                    }
                    if (!__superior.recipient.isEmpty()) {
                        this.recipient.addAll(__superior.recipient);
                    }
                    if (__superior.ignoreresult != null) {
                        this.ignoreresult(__superior.ignoreresult);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder selector(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.selector = __value;
                    this.__uninitialized.remove("selector");
                    return this;
                }

                public Builder recipient(String __value) {
                    this.recipient.add(__value);
                    return this;
                }

                public Builder recipient(Collection<String> __values) {
                    this.recipient.addAll(__values);
                    return this;
                }

                public Builder ignoreresult(boolean __value) {
                    this.ignoreresult = __value;
                    return this;
                }

                private Builder ignoreresult(String __value) {
                    return this.ignoreresult(Boolean.valueOf(__value));
                }

                public Hop build() {
                    return new Hop(this);
                }
            }
        }

        public static final class Route
        extends InnerNode {
            private final StringNode name;
            private final LeafNodeVector<String, StringNode> hop;

            public Route(Builder builder) {
                this(builder, true);
            }

            private Route(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for messagebus.routingtable[].route[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.hop = new LeafNodeVector(builder.hop, (LeafNode)new StringNode());
            }

            public String name() {
                return this.name.value();
            }

            public List<String> hop() {
                return this.hop.asList();
            }

            public String hop(int i) {
                return ((StringNode)this.hop.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
                return changes;
            }

            private static InnerNodeVector<Route> createVector(List<Builder> builders) {
                ArrayList<Route> elems = new ArrayList<Route>();
                for (Builder b : builders) {
                    elems.add(new Route(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
                private String name = null;
                public List<String> hop = new ArrayList<String>();

                public Builder() {
                }

                public Builder(Route config) {
                    this.name(config.name());
                    this.hop(config.hop());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (!__superior.hop.isEmpty()) {
                        this.hop.addAll(__superior.hop);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder hop(String __value) {
                    this.hop.add(__value);
                    return this;
                }

                public Builder hop(Collection<String> __values) {
                    this.hop.addAll(__values);
                    return this;
                }

                public Route build() {
                    return new Route(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

