/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.component.Version;
import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCSend;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.security.tls.Capability;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8Array;

public class RPCSendV2
extends RPCSend {
    private static final String METHOD_NAME = "mbus.slime";
    private static final String METHOD_PARAMS = "bixbix";
    private static final String METHOD_RETURN = "bixbix";
    private final Compressor compressor = new Compressor(CompressionType.LZ4, 3, 0.9, 1024);
    private static final String VERSION_F = "version";
    private static final String ROUTE_F = "route";
    private static final String SESSION_F = "session";
    private static final String PROTOCOL_F = "prot";
    private static final String TRACELEVEL_F = "tracelevel";
    private static final String TRACE_F = "trace";
    private static final String USERETRY_F = "useretry";
    private static final String RETRY_F = "retry";
    private static final String RETRYDELAY_F = "retrydelay";
    private static final String TIMEREMAINING_F = "timeleft";
    private static final String ERRORS_F = "errors";
    private static final String SERVICE_F = "service";
    private static final String CODE_F = "code";
    private static final String BLOB_F = "msg";
    private static final String MSG_F = "msg";

    protected RPCSendV2(RPCNetwork net) {
        super(net);
    }

    @Override
    protected String getReturnSpec() {
        return "bixbix";
    }

    @Override
    protected Method buildMethod() {
        Method method = new Method(METHOD_NAME, "bixbix", "bixbix", (MethodHandler)this).requireCapabilities(new Capability[]{Capability.CONTAINER__DOCUMENT_API});
        method.methodDesc("Send a message bus request and get a reply back.");
        method.paramDesc(0, "header_encoding", "Encoding type of header.").paramDesc(1, "header_decodedSize", "Number of bytes after header decoding.").paramDesc(2, "header_payload", "Slime encoded header payload.").paramDesc(3, "body_encoding", "Encoding type of body.").paramDesc(4, "body_decoded_ize", "Number of bytes after body decoding.").paramDesc(5, "body_payload", "Slime encoded body payload.");
        method.returnDesc(0, "header_encoding", "Encoding type of header.").returnDesc(1, "header_decoded_size", "Number of bytes after header decoding.").returnDesc(2, "header_payload", "Slime encoded header payload.").returnDesc(3, "body_encoding", "Encoding type of body.").returnDesc(4, "body_encoded_size", "Number of bytes after body decoding.").returnDesc(5, "body_payload", "Slime encoded body payload.");
        return method;
    }

    @Override
    protected Request encodeRequest(Version version, Route route, RPCServiceAddress address, Message msg, long timeRemaining, byte[] payload, int traceLevel) {
        Request req = new Request(METHOD_NAME);
        Values v = req.parameters();
        v.add((Value)new Int8Value(CompressionType.NONE.getCode()));
        v.add((Value)new Int32Value(0));
        v.add((Value)new DataValue(new byte[0]));
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString(VERSION_F, version.toUtf8().getBytes());
        root.setString(ROUTE_F, route.toString());
        root.setString(SESSION_F, address.getSessionName());
        root.setString(PROTOCOL_F, msg.getProtocol().toString());
        root.setBool(USERETRY_F, msg.getRetryEnabled());
        root.setLong(RETRY_F, (long)msg.getRetry());
        root.setLong(TIMEREMAINING_F, msg.getTimeRemaining());
        root.setLong(TRACELEVEL_F, (long)traceLevel);
        root.setData("msg", payload);
        Compressor.Compression compressionResult = BinaryFormat.encode_and_compress((Slime)slime, (Compressor)this.compressor);
        v.add((Value)new Int8Value(compressionResult.type().getCode()));
        v.add((Value)new Int32Value(compressionResult.uncompressedSize()));
        v.add((Value)new DataValue(compressionResult.data()));
        return req;
    }

    @Override
    protected Reply createReply(Values ret, String serviceName, Trace trace) {
        CompressionType compression = CompressionType.valueOf((byte)ret.get(3).asInt8());
        byte[] slimeBytes = this.compressor.decompress(ret.get(5).asData(), compression, ret.get(4).asInt32());
        Slime slime = BinaryFormat.decode((byte[])slimeBytes);
        Cursor root = slime.get();
        Version version = new Version(new Utf8Array(root.field(VERSION_F).asUtf8()));
        byte[] payload = root.field("msg").asData();
        Reply reply = null;
        Error error = null;
        if (payload.length > 0) {
            Object retval = this.decode(new Utf8Array(root.field(PROTOCOL_F).asUtf8()), version, payload);
            if (retval instanceof Reply) {
                reply = (Reply)retval;
            } else {
                error = (Error)retval;
            }
        }
        if (reply == null) {
            reply = new EmptyReply();
        }
        if (error != null) {
            reply.addError(error);
        }
        reply.setRetryDelay(root.field(RETRYDELAY_F).asDouble());
        Inspector errors = root.field(ERRORS_F);
        for (int i = 0; i < errors.entries(); ++i) {
            Inspector e = errors.entry(i);
            String service = e.field(SERVICE_F).asString();
            reply.addError(new Error((int)e.field(CODE_F).asLong(), e.field("msg").asString(), service != null && service.length() > 0 ? service : serviceName));
        }
        if (trace.getLevel() > 0) {
            trace.getRoot().addChild(TraceNode.decode(root.field(TRACE_F).asString()));
        }
        return reply;
    }

    @Override
    protected RPCSend.Params toParams(Values args) {
        CompressionType compression = CompressionType.valueOf((byte)args.get(3).asInt8());
        byte[] slimeBytes = this.compressor.decompress(args.get(5).asData(), compression, args.get(4).asInt32());
        Slime slime = BinaryFormat.decode((byte[])slimeBytes);
        Cursor root = slime.get();
        RPCSend.Params p = new RPCSend.Params(this);
        p.version = new Version(new Utf8Array(root.field(VERSION_F).asUtf8()));
        p.route = root.field(ROUTE_F).asString();
        p.session = root.field(SESSION_F).asString();
        p.retryEnabled = root.field(USERETRY_F).asBool();
        p.retry = (int)root.field(RETRY_F).asLong();
        p.timeRemaining = root.field(TIMEREMAINING_F).asLong();
        p.protocolName = new Utf8Array(root.field(PROTOCOL_F).asUtf8());
        p.payload = root.field("msg").asData();
        p.traceLevel = (int)root.field(TRACELEVEL_F).asLong();
        return p;
    }

    @Override
    protected void createResponse(Values ret, Reply reply, Version version, byte[] payload) {
        ret.add((Value)new Int8Value(CompressionType.NONE.getCode()));
        ret.add((Value)new Int32Value(0));
        ret.add((Value)new DataValue(new byte[0]));
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString(VERSION_F, version.toUtf8().getBytes());
        root.setDouble(RETRYDELAY_F, reply.getRetryDelay());
        root.setString(PROTOCOL_F, reply.getProtocol().getBytes());
        root.setData("msg", payload);
        if (reply.getTrace().getLevel() > 0) {
            root.setString(TRACE_F, reply.getTrace().getRoot().encode());
        }
        if (reply.getNumErrors() > 0) {
            Cursor array = root.setArray(ERRORS_F);
            for (int i = 0; i < reply.getNumErrors(); ++i) {
                Cursor e = array.addObject();
                Error mbusE = reply.getError(i);
                e.setLong(CODE_F, (long)mbusE.getCode());
                e.setString("msg", mbusE.getMessage());
                if (mbusE.getService() == null) continue;
                e.setString(SERVICE_F, mbusE.getService());
            }
        }
        Compressor.Compression compressionResult = BinaryFormat.encode_and_compress((Slime)slime, (Compressor)this.compressor);
        ret.add((Value)new Int8Value(compressionResult.type().getCode()));
        ret.add((Value)new Int32Value(compressionResult.uncompressedSize()));
        ret.add((Value)new DataValue(compressionResult.data()));
    }
}

