/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.test;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class QueueAdapter
implements MessageHandler,
ReplyHandler {
    private final Queue<Routable> queue = new ConcurrentLinkedQueue<Routable>();

    @Override
    public void handleMessage(Message message) {
        this.queue.offer(message);
    }

    @Override
    public void handleReply(Reply reply) {
        this.queue.offer(reply);
    }

    public Routable dequeue() {
        return this.queue.poll();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public boolean waitSize(int size, int seconds) {
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(seconds);
        while (this.size() != size) {
            if (System.currentTimeMillis() > timeout) {
                return false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }
}

