/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RPCService {
    private final IMirror mirror;
    private final String pattern;
    private int addressIdx = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    private int addressGen = 0;
    private List<Mirror.Entry> addressList = null;

    public RPCService(IMirror mirror, String pattern) {
        this.mirror = mirror;
        this.pattern = pattern;
    }

    public RPCServiceAddress resolve() {
        if (this.pattern.startsWith("tcp/")) {
            RPCServiceAddress ret;
            int pos = this.pattern.lastIndexOf(47);
            if (pos > 0 && pos < this.pattern.length() - 1 && !(ret = new RPCServiceAddress(this.pattern, this.pattern.substring(0, pos))).isMalformed()) {
                return ret;
            }
        } else {
            if (this.addressGen != this.mirror.updates()) {
                this.addressGen = this.mirror.updates();
                this.addressList = this.mirror.lookup(this.pattern);
            }
            if (this.addressList != null && !this.addressList.isEmpty()) {
                ++this.addressIdx;
                if (this.addressIdx >= this.addressList.size()) {
                    this.addressIdx = 0;
                }
                Mirror.Entry entry = this.addressList.get(this.addressIdx);
                return new RPCServiceAddress(entry.getName(), entry.getSpec());
            }
        }
        return null;
    }

    String getPattern() {
        return this.pattern;
    }
}

