/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import com.yahoo.messagebus.network.rpc.RPCTarget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RPCTargetPool {
    private final Map<String, Entry> targets = new HashMap<String, Entry>();
    private final Timer timer;
    private final long expireMillis;

    public RPCTargetPool(double expireSecs) {
        this((Timer)SystemTimer.INSTANCE, expireSecs);
    }

    public RPCTargetPool(Timer timer, double expireSecs) {
        this.timer = timer;
        this.expireMillis = (long)(expireSecs * 1000.0);
    }

    public synchronized void flushTargets(boolean force) {
        Iterator<Entry> it = this.targets.values().iterator();
        long currentTime = this.timer.milliTime();
        long expireTime = currentTime - this.expireMillis;
        while (it.hasNext()) {
            Entry entry = it.next();
            RPCTarget target = entry.target;
            if (target.getJRTTarget().isValid()) {
                if (target.getRefCount() > 1) {
                    entry.lastUse = currentTime;
                    continue;
                }
                if (!force && entry.lastUse > expireTime) continue;
            }
            target.subRef();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCTarget getTarget(Supervisor orb, RPCServiceAddress address) {
        RPCTarget ret;
        Spec spec = address.getConnectionSpec();
        String key = spec.toString();
        RPCTargetPool rPCTargetPool = this;
        synchronized (rPCTargetPool) {
            Entry entry = this.targets.get(key);
            if (entry != null) {
                if (entry.target.getJRTTarget().isValid()) {
                    entry.target.addRef();
                    entry.lastUse = this.timer.milliTime();
                    return entry.target;
                }
                entry.target.subRef();
                this.targets.remove(key);
            }
            ret = new RPCTarget(spec, orb);
            this.targets.put(key, new Entry(ret, this.timer.milliTime()));
        }
        ret.addRef();
        return ret;
    }

    public synchronized int size() {
        return this.targets.size();
    }

    private static class Entry {
        final RPCTarget target;
        long lastUse = 0L;

        Entry(RPCTarget target, long lastUse) {
            this.target = target;
            this.lastUse = lastUse;
        }
    }
}

