/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc.test;

import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.slobrok.server.Slobrok;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.local.LocalNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.network.rpc.test.SlobrokState;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestServer {
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    public final VersionedRPCNetwork net;
    public final MessageBus mb;

    public TestServer(String name, RoutingTableSpec table, Slobrok slobrok, Protocol protocol) {
        this(new MessageBusParams().addProtocol(new SimpleProtocol()), new RPCNetworkParams().setIdentity(new Identity(name)).setSlobrokConfigId(TestServer.getSlobrokConfig(slobrok)));
        if (protocol != null) {
            this.mb.putProtocol(protocol);
        }
        if (table != null) {
            this.setupRouting(table);
        }
    }

    public TestServer(MessageBusParams mbusParams, RPCNetworkParams netParams) {
        this.net = new VersionedRPCNetwork(netParams);
        this.mb = new MessageBus((Network)this.net, mbusParams);
    }

    public TestServer(MessageBusParams mbusParams) {
        this.mb = new MessageBus((Network)new LocalNetwork(), mbusParams);
        this.net = null;
    }

    public boolean destroy() {
        if (!this.destroyed.getAndSet(true)) {
            this.mb.destroy();
            if (this.net != null) {
                this.net.destroy();
            }
            return true;
        }
        return false;
    }

    public static String getSlobrokConfig(Slobrok slobrok) {
        return "raw:slobrok[1]\nslobrok[0].connectionspec \"" + new Spec("localhost", slobrok.port()).toString() + "\"\n";
    }

    public void setupRouting(RoutingTableSpec table) {
        this.mb.setupRouting(new RoutingSpec().addTable(table));
    }

    public boolean waitSlobrok(String pattern, int cnt) {
        return this.waitState(new SlobrokState().add(pattern, cnt));
    }

    public boolean waitState(SlobrokState slobrokState) {
        for (int i = 0; i < 6000 && !Thread.currentThread().isInterrupted(); ++i) {
            boolean done = true;
            for (String pattern : slobrokState.getPatterns()) {
                List res = this.net.getMirror().lookup(pattern);
                if (res.size() == slobrokState.getCount(pattern)) continue;
                done = false;
            }
            if (done) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static class VersionedRPCNetwork
    extends RPCNetwork {
        private Version version = Vtag.currentVersion;

        public VersionedRPCNetwork(RPCNetworkParams netParams) {
            super(netParams);
        }

        @Override
        protected Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
            this.flushTargetPool();
        }
    }
}

