/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.messagebus.network.Identity;

public class RPCNetworkParams {
    private Identity identity = new Identity("");
    private String slobrokConfigId = "admin/slobrok.0";
    private SlobroksConfig slobroksConfig = null;
    private int listenPort = 0;
    private int maxInputBufferSize = 262144;
    private int maxOutputBufferSize = 262144;
    private double connectionExpireSecs = 30.0;
    private int numTargetsPerSpec = 1;
    private int numNetworkThreads = 2;
    private int transportEventsBeforeWakeup = 1;
    Optimization optimization = Optimization.LATENCY;

    public RPCNetworkParams() {
    }

    public RPCNetworkParams(RPCNetworkParams params) {
        this.identity = new Identity(params.identity);
        this.slobrokConfigId = params.slobrokConfigId;
        this.slobroksConfig = params.slobroksConfig;
        this.listenPort = params.listenPort;
        this.connectionExpireSecs = params.connectionExpireSecs;
        this.maxInputBufferSize = params.maxInputBufferSize;
        this.maxOutputBufferSize = params.maxOutputBufferSize;
        this.numTargetsPerSpec = params.numTargetsPerSpec;
        this.numNetworkThreads = params.numNetworkThreads;
        this.optimization = params.optimization;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public RPCNetworkParams setIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public String getSlobrokConfigId() {
        return this.slobrokConfigId;
    }

    public RPCNetworkParams setSlobrokConfigId(String slobrokConfigId) {
        this.slobrokConfigId = slobrokConfigId;
        return this;
    }

    public SlobroksConfig getSlobroksConfig() {
        return this.slobroksConfig;
    }

    public RPCNetworkParams setSlobroksConfig(SlobroksConfig slobroksConfig) {
        this.slobroksConfig = slobroksConfig;
        return this;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public RPCNetworkParams setListenPort(int listenPort) {
        this.listenPort = listenPort;
        return this;
    }

    public double getConnectionExpireSecs() {
        return this.connectionExpireSecs;
    }

    public RPCNetworkParams setConnectionExpireSecs(double secs) {
        this.connectionExpireSecs = secs;
        return this;
    }

    public RPCNetworkParams setNumTargetsPerSpec(int numTargetsPerSpec) {
        this.numTargetsPerSpec = numTargetsPerSpec;
        return this;
    }

    int getNumTargetsPerSpec() {
        return this.numTargetsPerSpec;
    }

    public RPCNetworkParams setNumNetworkThreads(int numNetworkThreads) {
        this.numNetworkThreads = numNetworkThreads;
        return this;
    }

    int getNumNetworkThreads() {
        return this.numNetworkThreads;
    }

    public RPCNetworkParams setOptimization(Optimization optimization) {
        this.optimization = optimization;
        return this;
    }

    Optimization getOptimization() {
        return this.optimization;
    }

    public int getMaxInputBufferSize() {
        return this.maxInputBufferSize;
    }

    RPCNetworkParams setMaxInputBufferSize(int maxInputBufferSize) {
        this.maxInputBufferSize = maxInputBufferSize;
        return this;
    }

    int getMaxOutputBufferSize() {
        return this.maxOutputBufferSize;
    }

    RPCNetworkParams setMaxOutputBufferSize(int maxOutputBufferSize) {
        this.maxOutputBufferSize = maxOutputBufferSize;
        return this;
    }

    public int getTransportEventsBeforeWakeup() {
        return this.transportEventsBeforeWakeup;
    }

    public RPCNetworkParams setTransportEventsBeforeWakeup(int transportEventsBeforeWakeup) {
        this.transportEventsBeforeWakeup = transportEventsBeforeWakeup;
        return this;
    }

    public static enum Optimization {
        LATENCY,
        THROUGHPUT;

    }
}

