/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.TraceNode;

public class Trace {
    private int level = 0;
    private TraceNode root = new TraceNode();

    public Trace() {
    }

    public Trace(int level) {
        this.level = level;
    }

    public Trace clear() {
        this.level = 0;
        this.root = new TraceNode();
        return this;
    }

    public Trace swap(Trace other) {
        int level = this.level;
        this.level = other.level;
        other.level = level;
        TraceNode root = this.root;
        this.root = other.root;
        other.root = root;
        return this;
    }

    public Trace setLevel(int level) {
        this.level = Math.min(Math.max(level, 0), 9);
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean shouldTrace(int level) {
        return level <= this.level;
    }

    public boolean trace(int level, String note) {
        return this.trace(level, note, true);
    }

    public boolean trace(int level, String note, boolean addTime) {
        if (!this.shouldTrace(level)) {
            return false;
        }
        if (addTime) {
            String timeString = Long.toString(System.currentTimeMillis());
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            int len = timeString.length();
            if (len < 3) {
                buf.append(timeString);
            } else {
                buf.append(timeString.substring(0, len - 3));
                buf.append('.');
                buf.append(timeString.substring(len - 3));
            }
            buf.append("] ");
            buf.append(note);
            this.root.addChild(buf.toString());
        } else {
            this.root.addChild(note);
        }
        return true;
    }

    public TraceNode getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString(31337);
    }
}

