/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.test;

import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Receptor
implements MessageHandler,
ReplyHandler {
    private final BlockingQueue<Message> msg = new LinkedBlockingQueue<Message>();
    private final BlockingQueue<Reply> reply = new LinkedBlockingQueue<Reply>();

    public void reset() {
        this.msg.clear();
        this.reply.clear();
    }

    @Override
    public void handleMessage(Message msg) {
        this.msg.add(msg);
    }

    @Override
    public void handleReply(Reply reply) {
        this.reply.add(reply);
    }

    public Message getMessage(int seconds) {
        try {
            return this.msg.poll(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public Reply getReply(int seconds) {
        try {
            return this.reply.poll(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

