/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.ErrorCode;
import java.io.Serializable;

public final class Error {
    private final int code;
    private final String message;
    private final String service;

    public Error(int code, String message) {
        this.code = code;
        this.message = message;
        this.service = null;
    }

    public Error(int code, String message, String service) {
        this.code = code;
        this.message = message;
        this.service = service;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getService() {
        return this.service;
    }

    public boolean isFatal() {
        return this.code >= 200000;
    }

    public String toString() {
        String name = ErrorCode.getName(this.code);
        return "[" + (Serializable)(name != null ? name : Integer.valueOf(this.code)) + " @ " + (this.service != null ? this.service : "localhost") + "]: " + this.message;
    }
}

