/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.TraceNode;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.ServiceAddress;
import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopBlueprint;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.PolicyDirective;
import com.yahoo.messagebus.routing.Resender;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RouteDirective;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.messagebus.routing.RoutingTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class RoutingNode
implements ReplyHandler {
    private final MessageBus mbus;
    private final Network net;
    private final Resender resender;
    private final RoutingNode parent;
    private final List<Route> recipients = new ArrayList<Route>();
    private final List<RoutingNode> children = new ArrayList<RoutingNode>();
    private final ReplyHandler handler;
    private final Trace trace;
    private final AtomicInteger pending = new AtomicInteger(0);
    private final Message msg;
    private Reply reply = null;
    private Route route;
    private RoutingPolicy policy = null;
    private RoutingContext routingContext = null;
    private ServiceAddress serviceAddress = null;
    private boolean isActive = true;
    private boolean shouldRetry = false;

    public RoutingNode(MessageBus mbus, Network net, Resender resender, ReplyHandler handler, Message msg) {
        this.mbus = mbus;
        this.net = net;
        this.resender = resender;
        this.handler = handler;
        this.msg = msg;
        this.trace = new Trace(msg.getTrace().getLevel());
        this.route = msg.getRoute();
        this.parent = null;
    }

    private RoutingNode(RoutingNode parent, Route route) {
        this.mbus = parent.mbus;
        this.net = parent.net;
        this.resender = parent.resender;
        this.handler = null;
        this.msg = parent.msg;
        this.trace = new Trace(parent.trace.getLevel());
        this.route = new Route(route);
        this.parent = parent;
        this.recipients.addAll(parent.recipients);
    }

    public void discard() {
        if (this.handler != null) {
            this.handler.handleReply(null);
        } else if (this.parent != null) {
            this.parent.discard();
        }
    }

    public void send() {
        if (!this.resolve(0)) {
            this.notifyAbort("Route resolution failed.");
        } else {
            String errors = this.getUnconsumedErrors();
            if (errors != null) {
                this.notifyAbort("Errors found while resolving route: " + errors);
            } else {
                this.notifyTransmit();
            }
        }
    }

    private void notifyAbort(String msg) {
        Stack<RoutingNode> stack = new Stack<RoutingNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            RoutingNode node = (RoutingNode)stack.pop();
            if (!node.isActive) continue;
            if (node.reply != null) {
                node.notifyParent();
                continue;
            }
            if (node.children.isEmpty()) {
                node.setError(100006, msg);
                node.notifyParent();
                continue;
            }
            for (RoutingNode child : node.children) {
                stack.push(child);
            }
        }
    }

    private void notifyTransmit() {
        ArrayList<RoutingNode> sendTo = new ArrayList<RoutingNode>();
        ArrayDeque<RoutingNode> stack = new ArrayDeque<RoutingNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            RoutingNode node = (RoutingNode)stack.pop();
            if (!node.isActive) continue;
            if (node.children.isEmpty()) {
                if (node.reply != null) {
                    node.notifyParent();
                    continue;
                }
                sendTo.add(node);
                continue;
            }
            for (RoutingNode child : node.children) {
                stack.push(child);
            }
        }
        if (!sendTo.isEmpty()) {
            this.net.send(this.msg, sendTo);
        }
    }

    private void notifySender() {
        this.reply.getTrace().swap(this.trace);
        this.handler.handleReply(this.reply);
        this.reply = null;
    }

    private void notifyParent() {
        if (this.serviceAddress != null) {
            this.net.freeServiceAddress(this);
        }
        this.tryIgnoreResult();
        if (this.parent != null) {
            this.parent.notifyMerge();
            return;
        }
        if (this.shouldRetry && this.resender.scheduleRetry(this)) {
            return;
        }
        this.notifySender();
    }

    private void notifyMerge() {
        if (this.pending.decrementAndGet() != 0) {
            return;
        }
        if (this.trace.getLevel() > 0) {
            TraceNode tail = new TraceNode();
            for (RoutingNode child : this.children) {
                TraceNode root = child.trace.getRoot();
                tail.addChild(root);
                root.clear();
            }
            tail.setStrict(false);
            this.trace.getRoot().addChild(tail);
        }
        PolicyDirective dir = this.routingContext.getDirective();
        if (this.trace.shouldTrace(5)) {
            this.trace.trace(5, "Routing policy '" + dir.getName() + "' merging replies.");
        }
        try {
            this.policy.merge(this.routingContext);
        }
        catch (RuntimeException e) {
            this.setError(200013, "Policy '" + dir.getName() + "' and route '" + this.route + "' threw an exception during merge; " + RoutingNode.exceptionMessageWithTrace(e));
        }
        if (this.reply == null) {
            this.setError(250000, "Routing policy '" + this.routingContext.getDirective().getName() + "' failed to merge replies.");
        }
        this.notifyParent();
    }

    private boolean shouldIgnoreResult() {
        return this.route != null && this.route.getNumHops() > 0 && this.route.getHop(0).getIgnoreResult();
    }

    private boolean tryIgnoreResult() {
        if (!this.shouldIgnoreResult()) {
            return false;
        }
        if (this.reply == null || !this.reply.hasErrors()) {
            return false;
        }
        this.setReply(new EmptyReply());
        this.trace.trace(5, "Ignoring errors in reply.");
        return true;
    }

    void prepareForRetry() {
        this.shouldRetry = false;
        this.reply = null;
        if (this.routingContext != null && this.routingContext.getSelectOnRetry()) {
            this.children.clear();
        } else if (!this.children.isEmpty()) {
            boolean retryingSome = false;
            for (RoutingNode child : this.children) {
                if (!child.shouldRetry && child.reply != null) continue;
                child.prepareForRetry();
                retryingSome = true;
            }
            if (!retryingSome) {
                this.children.clear();
            }
        }
    }

    private String getUnconsumedErrors() {
        StringBuilder errors = null;
        ArrayDeque<RoutingNode> stack = new ArrayDeque<RoutingNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            RoutingNode node = (RoutingNode)stack.pop();
            if (node.reply != null) {
                for (int i = 0; i < node.reply.getNumErrors(); ++i) {
                    Error error = node.reply.getError(i);
                    int errorCode = error.getCode();
                    RoutingNode it = node;
                    while (it != null) {
                        if (it.routingContext != null && it.routingContext.isConsumableError(errorCode)) {
                            errorCode = 0;
                            break;
                        }
                        it = it.parent;
                    }
                    if (errorCode == 0) continue;
                    if (errors == null) {
                        errors = new StringBuilder();
                    } else {
                        errors.append("\n");
                    }
                    errors.append(error.toString());
                    boolean bl = this.shouldRetry = this.resender != null && this.resender.canRetry(errorCode);
                    if (this.shouldRetry) continue;
                    return errors.toString();
                }
                continue;
            }
            for (RoutingNode child : node.children) {
                stack.push(child);
            }
        }
        return errors != null ? errors.toString() : null;
    }

    private boolean resolve(int depth) {
        if (this.route == null || !this.route.hasHops()) {
            this.setError(200002, "Route has no hops.");
            return false;
        }
        if (!this.children.isEmpty()) {
            return this.resolveChildren(depth + 1);
        }
        while ((this.lookupHop() || this.lookupRoute()) && ++depth <= 64) {
        }
        if (depth > 64) {
            this.setError(200002, "Depth limit exceeded.");
            return false;
        }
        if (this.findErrorDirective()) {
            return false;
        }
        if (this.findPolicyDirective()) {
            if (this.executePolicySelect()) {
                return this.resolveChildren(depth + 1);
            }
            return this.reply != null;
        }
        this.net.allocServiceAddress(this);
        return this.serviceAddress != null || this.reply != null;
    }

    private boolean lookupHop() {
        String name;
        RoutingTable table = this.mbus.getRoutingTable(this.msg.getProtocol());
        if (table != null && table.hasHop(name = this.route.getHop(0).getServiceName())) {
            HopBlueprint hop = table.getHop(name);
            this.configureFromBlueprint(hop);
            if (this.trace.shouldTrace(5)) {
                this.trace.trace(5, "Recognized '" + name + "' as " + hop + ".");
            }
            return true;
        }
        return false;
    }

    private boolean lookupRoute() {
        String name;
        RoutingTable table = this.mbus.getRoutingTable(this.msg.getProtocol());
        Hop hop = this.route.getHop(0);
        if (hop.getDirective(0) instanceof RouteDirective) {
            RouteDirective dir = (RouteDirective)hop.getDirective(0);
            if (table == null || !table.hasRoute(dir.getName())) {
                this.setError(200002, "Route '" + dir.getName() + "' does not exist.");
                return false;
            }
            this.insertRoute(table.getRoute(dir.getName()));
            if (this.trace.shouldTrace(5)) {
                this.trace.trace(5, "Route '" + dir.getName() + "' retrieved by directive; new route is '" + this.route + "'.");
            }
            return true;
        }
        if (table != null && table.hasRoute(name = hop.getServiceName())) {
            this.insertRoute(table.getRoute(name));
            if (this.trace.shouldTrace(5)) {
                this.trace.trace(5, "Recognized '" + name + "' as route '" + this.route + "'.");
            }
            return true;
        }
        return false;
    }

    private void insertRoute(Route ins) {
        Route route = new Route(ins);
        if (this.shouldIgnoreResult()) {
            route.getHop(0).setIgnoreResult(true);
        }
        for (int i = 1; i < this.route.getNumHops(); ++i) {
            route.addHop(this.route.getHop(i));
        }
        this.route = route;
    }

    private boolean findErrorDirective() {
        Hop hop = this.route.getHop(0);
        for (int i = 0; i < hop.getNumDirectives(); ++i) {
            HopDirective dir = hop.getDirective(i);
            if (!(dir instanceof ErrorDirective)) continue;
            this.setError(200002, ((ErrorDirective)dir).getMessage());
            return true;
        }
        return false;
    }

    private boolean findPolicyDirective() {
        Hop hop = this.route.getHop(0);
        for (int i = 0; i < hop.getNumDirectives(); ++i) {
            HopDirective dir = hop.getDirective(i);
            if (!(dir instanceof PolicyDirective)) continue;
            this.routingContext = new RoutingContext(this, i);
            return true;
        }
        return false;
    }

    private static String exceptionMessageWithTrace(Exception e) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            pw.flush();
        }
        return sw.toString();
    }

    private boolean executePolicySelect() {
        PolicyDirective dir = this.routingContext.getDirective();
        this.policy = this.mbus.getRoutingPolicy(this.msg.getProtocol(), dir.getName(), dir.getParam());
        if (this.policy == null) {
            this.setError(200011, "Protocol '" + this.msg.getProtocol() + "' could not create routing policy '" + dir.getName() + "' with parameter '" + dir.getParam() + "'.");
            return false;
        }
        if (this.trace.shouldTrace(5)) {
            this.trace.trace(5, "Running routing policy '" + dir.getName() + "'.");
        }
        try {
            this.policy.select(this.routingContext);
        }
        catch (RuntimeException e) {
            this.setError(200013, "Policy '" + dir.getName() + "' and route '" + this.route + "' threw an exception during select; " + RoutingNode.exceptionMessageWithTrace(e));
            return false;
        }
        if (this.children.isEmpty()) {
            if (this.reply == null) {
                this.setError(200003, "Policy '" + dir.getName() + "' selected no recipients for route '" + this.route + "'.");
            } else if (this.trace.shouldTrace(5)) {
                this.trace.trace(5, "Policy '" + dir.getName() + "' assigned a reply to this branch.");
            }
            return false;
        }
        for (RoutingNode child : this.children) {
            if (!child.trace.shouldTrace(5)) continue;
            Hop hop = child.route.getHop(0);
            child.trace.trace(5, "Component '" + hop + "' selected by policy '" + dir.getName() + "'.");
        }
        return true;
    }

    private boolean resolveChildren(int childDepth) {
        int numActiveChildren = 0;
        boolean ret = true;
        for (RoutingNode child : this.children) {
            if (child.trace.shouldTrace(5)) {
                child.trace.trace(5, "Resolving '" + child.route + "'.");
            }
            boolean bl = child.isActive = child.reply == null;
            if (child.isActive) {
                ++numActiveChildren;
                if (child.resolve(childDepth)) continue;
                ret = false;
                break;
            }
            if (!child.trace.shouldTrace(5)) continue;
            child.trace.trace(5, "Already completed.");
        }
        this.pending.set(numActiveChildren);
        return ret;
    }

    void addChild(Route route) {
        RoutingNode child = new RoutingNode(this, route);
        if (this.shouldIgnoreResult()) {
            child.route.getHop(0).setIgnoreResult(true);
        }
        this.children.add(child);
    }

    private void configureFromBlueprint(HopBlueprint hop) {
        boolean ignoreResult = this.shouldIgnoreResult();
        this.route.setHop(0, hop.create());
        if (ignoreResult) {
            this.route.getHop(0).setIgnoreResult(true);
        }
        this.recipients.clear();
        for (int r = 0; r < hop.getNumRecipients(); ++r) {
            Route recipient = new Route();
            recipient.addHop(hop.getRecipient(r));
            for (int h = 1; h < this.route.getNumHops(); ++h) {
                recipient.addHop(this.route.getHop(h));
            }
            this.recipients.add(recipient);
        }
    }

    public void setError(int code, String msg) {
        this.setError(new Error(code, msg));
    }

    public void setError(Error err) {
        EmptyReply reply = new EmptyReply();
        reply.getTrace().setLevel(this.trace.getLevel());
        reply.addError(err);
        this.setReply(reply);
    }

    public void addError(int code, String msg) {
        this.addError(new Error(code, msg));
    }

    public void addError(Error err) {
        if (this.reply != null) {
            this.reply.getTrace().swap(this.trace);
            this.reply.addError(err);
            this.reply.getTrace().swap(this.trace);
        } else {
            this.setError(err);
        }
    }

    MessageBus getMessageBus() {
        return this.mbus;
    }

    Network getNetwork() {
        return this.net;
    }

    public Message getMessage() {
        return this.msg;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Route getRoute() {
        return this.route;
    }

    boolean hasReply() {
        return this.reply != null;
    }

    Reply getReply() {
        return this.reply;
    }

    public void setReply(Reply reply) {
        if (reply != null) {
            this.shouldRetry = this.resender != null && this.resender.shouldRetry(reply);
            this.trace.getRoot().addChild(reply.getTrace().getRoot());
            reply.getTrace().clear();
        }
        this.reply = reply;
    }

    List<Route> getRecipients() {
        return this.recipients;
    }

    List<RoutingNode> getChildren() {
        return this.children;
    }

    public ServiceAddress getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(ServiceAddress serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    @Override
    public void handleReply(Reply reply) {
        this.setReply(reply);
        this.notifyParent();
    }
}

