/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.metrics;

import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.ErrorCode;
import com.yahoo.messagebus.metrics.AverageMetric;
import com.yahoo.messagebus.metrics.CountMetric;
import com.yahoo.messagebus.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;

public class RouteMetricSet
extends MetricSet {
    public MetricSet allErrors = new MetricSet("errors");
    public MetricSet failures = new MetricSet("failures");
    public AverageMetric latency = new AverageMetric("latency", this);
    private Map<Integer, CountMetric> errorMap = new HashMap<Integer, CountMetric>();

    RouteMetricSet(String route) {
        super(route);
        this.setXmlTagName("messages");
        this.addMetric(this.allErrors);
        this.addMetric(this.failures);
    }

    public void addError(Error e) {
        CountMetric metric = this.errorMap.get(e.getCode());
        if (metric == null) {
            metric = new CountMetric(ErrorCode.getName(e.getCode()), this.allErrors);
            metric.setXmlTagName("error");
            this.errorMap.put(e.getCode(), metric);
        }
        metric.inc(1L);
    }

    public void addFailure(Error e) {
        CountMetric metric = this.errorMap.get(e.getCode());
        if (metric == null) {
            metric = new CountMetric(ErrorCode.getName(e.getCode()), this.failures);
            metric.setXmlTagName("failure");
            this.errorMap.put(e.getCode(), metric);
        }
        metric.inc(1L);
    }
}

