/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.metrics;

import com.yahoo.messagebus.metrics.Metric;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XMLWriter;

public class AverageMetric
extends Metric {
    double sum = 0.0;
    double min = 0.0;
    double max = 0.0;
    int count = 0;
    private static final Utf8String attrValue = new Utf8String("value");
    private static final Utf8String attrCount = new Utf8String("count");
    private static final Utf8String attrMin = new Utf8String("min");
    private static final Utf8String attrMax = new Utf8String("max");

    public AverageMetric(String name, MetricSet owner) {
        super(name);
        owner.addMetric(this);
    }

    public void addValue(double value) {
        this.sum += value;
        ++this.count;
        if (this.min == 0.0 || value < this.min) {
            this.min = value;
        }
        if (this.max == 0.0 || value > this.max) {
            this.max = value;
        }
    }

    @Override
    public void toXML(XMLWriter writer) {
        this.renderXmlName(writer);
        if (this.count > 0) {
            writer.attribute(attrValue, this.sum / (double)this.count);
            writer.attribute(attrCount, (long)this.count);
            writer.attribute(attrMin, this.min);
            writer.attribute(attrMax, this.max);
        }
        writer.closeTag();
    }
}

