/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.metrics;

import com.yahoo.messagebus.metrics.Metric;
import com.yahoo.text.XMLWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetricSet
extends Metric {
    private List<Metric> metrics = new ArrayList<Metric>();

    public MetricSet(String name) {
        super(name);
    }

    public void addMetric(Metric m) {
        this.metrics.add(m);
    }

    public List<Metric> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    @Override
    public String toHTML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<ul>\n");
        for (Metric m : this.metrics) {
            builder.append("<li>\n").append(m.toHTML()).append("\n</li>");
        }
        builder.append("\n</ul>\n");
        return builder.toString();
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        this.renderXmlName(xmlWriter);
        for (Metric m : this.metrics) {
            m.toXML(xmlWriter);
        }
        xmlWriter.closeTag();
    }
}

