/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.log.LogLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class TraceNode
implements Comparable<TraceNode> {
    private static final Logger log = Logger.getLogger(TraceNode.class.getName());
    private TraceNode parent = null;
    private boolean strict = true;
    private String note = null;
    private List<TraceNode> children = new ArrayList<TraceNode>();

    public TraceNode() {
    }

    private TraceNode(String note) {
        this.note = note;
    }

    TraceNode(TraceNode rhs) {
        this.strict = rhs.strict;
        this.note = rhs.note;
        this.addChildren(rhs.children);
    }

    public TraceNode swap(TraceNode other) {
        TraceNode parent = this.parent;
        this.parent = other.parent;
        other.parent = parent;
        boolean strict = this.strict;
        this.strict = other.strict;
        other.strict = strict;
        String note = this.note;
        this.note = other.note;
        other.note = note;
        List<TraceNode> children = this.children;
        this.children = other.children;
        for (TraceNode child : this.children) {
            child.parent = this;
        }
        other.children = children;
        for (TraceNode child : other.children) {
            child.parent = other;
        }
        return this;
    }

    public TraceNode clear() {
        this.parent = null;
        this.strict = true;
        this.note = null;
        this.children.clear();
        return this;
    }

    public TraceNode sort() {
        if (!this.isLeaf()) {
            for (TraceNode child : this.children) {
                child.sort();
            }
            if (!this.isStrict()) {
                Collections.sort(this.children);
            }
        }
        return this;
    }

    @Override
    public int compareTo(TraceNode rhs) {
        if (this.isLeaf() || rhs.isLeaf()) {
            if (this.isLeaf() && rhs.isLeaf()) {
                return this.note.compareTo(rhs.getNote());
            }
            return this.isLeaf() ? -1 : 1;
        }
        if (this.children.size() != rhs.children.size()) {
            return this.children.size() < rhs.children.size() ? -1 : 1;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            int cmp = this.children.get(i).compareTo(rhs.children.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return -1;
    }

    public TraceNode compact() {
        if (this.isLeaf()) {
            return this;
        }
        List<TraceNode> tmp = this.children;
        this.children = new ArrayList<TraceNode>();
        for (TraceNode child : tmp) {
            child.compact();
            if (child.isEmpty()) continue;
            if (child.isLeaf()) {
                this.addChild(child);
                continue;
            }
            if (this.strict == child.strict) {
                this.addChildren(child.children);
                continue;
            }
            if (child.getNumChildren() == 1) {
                TraceNode grandChild = child.getChild(0);
                if (grandChild.isEmpty()) continue;
                if (grandChild.isLeaf() || this.strict != grandChild.strict) {
                    this.addChild(grandChild);
                    continue;
                }
                this.addChildren(grandChild.children);
                continue;
            }
            this.addChild(child);
        }
        return this;
    }

    public TraceNode normalize() {
        this.compact();
        this.sort();
        if (this.note != null || !this.strict) {
            TraceNode child = new TraceNode();
            child.swap(this);
            this.addChild(child);
            this.strict = true;
        }
        return this;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isEmpty() {
        return this.note == null && this.children.isEmpty();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public TraceNode setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public String getNote() {
        return this.note;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public TraceNode getChild(int i) {
        return this.children.get(i);
    }

    public TraceNode addChild(String note) {
        return this.addChild(new TraceNode(note));
    }

    public TraceNode addChild(TraceNode child) {
        if (this.note != null) {
            throw new IllegalStateException("Nodes with notes are leaf nodes, you can not add children to it.");
        }
        TraceNode node = new TraceNode(child);
        node.parent = this;
        this.children.add(node);
        return this;
    }

    public TraceNode addChildren(List<TraceNode> children) {
        for (TraceNode child : children) {
            this.addChild(child);
        }
        return this;
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toString(int limit) {
        StringBuilder out = new StringBuilder();
        if (!this.writeString(out, "", limit)) {
            out.append("...\n");
        }
        return out.toString();
    }

    private boolean writeString(StringBuilder ret, String indent, int limit) {
        if (ret.length() >= limit) {
            return false;
        }
        if (this.note != null) {
            ret.append(indent).append(this.note).append("\n");
        } else {
            String name = this.isStrict() ? "trace" : "fork";
            ret.append(indent).append("<").append(name).append(">\n");
            for (TraceNode child : this.children) {
                if (child.writeString(ret, indent + "    ", limit)) continue;
                return false;
            }
            if (ret.length() >= limit) {
                return false;
            }
            ret.append(indent).append("</").append(name).append(">\n");
        }
        return true;
    }

    public String encode() {
        StringBuilder ret = new StringBuilder();
        this.encode(ret);
        return ret.toString();
    }

    private void encode(StringBuilder ret) {
        if (this.note != null) {
            ret.append("[");
            int len = this.note.length();
            for (int i = 0; i < len; ++i) {
                char c = this.note.charAt(i);
                if (c == '\\' || c == ']') {
                    ret.append('\\');
                }
                ret.append(this.note.charAt(i));
            }
            ret.append("]");
        } else {
            ret.append(this.strict ? "(" : "{");
            for (TraceNode child : this.children) {
                child.encode(ret);
            }
            ret.append(this.strict ? ")" : "}");
        }
    }

    public static TraceNode decode(String str) {
        TraceNode proxy;
        if (str == null || str.isEmpty()) {
            return new TraceNode();
        }
        TraceNode node = proxy = new TraceNode();
        StringBuilder note = null;
        boolean inEscape = false;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (note != null) {
                if (inEscape) {
                    note.append(c);
                    inEscape = false;
                    continue;
                }
                if (c == '\\') {
                    inEscape = true;
                    continue;
                }
                if (c == ']') {
                    node.addChild(note.toString());
                    note = null;
                    continue;
                }
                note.append(c);
                continue;
            }
            if (c == '[') {
                note = new StringBuilder();
                continue;
            }
            if (c == '(' || c == '{') {
                node.addChild(new TraceNode());
                node = node.getChild(node.getNumChildren() - 1);
                node.setStrict(c == '(');
                continue;
            }
            if (c != ')' && c != '}') continue;
            if (node == null) {
                log.log(LogLevel.WARNING, "Unexpected closing brace in trace '" + str + "' at position " + i + ".");
                return new TraceNode();
            }
            if (node.isStrict() != (c == ')')) {
                log.log(LogLevel.WARNING, "Mismatched closing brace in trace '" + str + "' at position " + i + ".");
                return new TraceNode();
            }
            node = node.parent;
        }
        if (note != null) {
            log.log(LogLevel.WARNING, "Unterminated note in trace '" + str + "'.");
            return new TraceNode();
        }
        if (node != proxy) {
            log.log(LogLevel.WARNING, "Missing closing brace in trace '" + str + "'.");
            return new TraceNode();
        }
        if (proxy.getNumChildren() == 0) {
            log.log(LogLevel.WARNING, "No nodes found in trace '" + str + "'.");
            return new TraceNode();
        }
        if (proxy.getNumChildren() != 1) {
            return proxy;
        }
        TraceNode ret = proxy.children.remove(0);
        ret.parent = null;
        return ret;
    }
}

