/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public final class IntermediateSession
implements MessageHandler,
ReplyHandler {
    private static final Logger log = Logger.getLogger(IntermediateSession.class.getName());
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final String name;
    private final boolean broadcastName;
    private final MessageHandler msgHandler;
    private final ReplyHandler replyHandler;
    private final MessageBus mbus;

    IntermediateSession(MessageBus mbus, IntermediateSessionParams params) {
        this.mbus = mbus;
        this.name = params.getName();
        this.broadcastName = params.getBroadcastName();
        this.msgHandler = params.getMessageHandler();
        this.replyHandler = params.getReplyHandler();
    }

    public boolean destroy() {
        if (!this.destroyed.getAndSet(true)) {
            this.close();
            return true;
        }
        return false;
    }

    public void close() {
        this.mbus.unregisterSession(this.name, this.broadcastName);
        this.mbus.sync();
    }

    public void forward(Routable routable) {
        if (routable instanceof Reply) {
            Reply reply = (Reply)routable;
            ReplyHandler handler = reply.popHandler();
            handler.handleReply(reply);
        } else {
            routable.pushHandler(this);
            this.mbus.handleMessage((Message)routable);
        }
    }

    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    public ReplyHandler getReplyHandler() {
        return this.replyHandler;
    }

    public String getConnectionSpec() {
        return this.mbus.getConnectionSpec() + "/" + this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void handleMessage(Message msg) {
        this.msgHandler.handleMessage(msg);
    }

    @Override
    public void handleReply(Reply reply) {
        if (this.destroyed.get()) {
            reply.discard();
        } else {
            this.replyHandler.handleReply(reply);
        }
    }
}

