/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Routable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public abstract class Reply
extends Routable {
    private double retryDelay = -1.0;
    private Message msg = null;
    private List<Error> errors = new ArrayList<Error>();

    @Override
    public void swapState(Routable rhs) {
        super.swapState(rhs);
        if (rhs instanceof Reply) {
            Reply reply = (Reply)rhs;
            double retryDelay = this.retryDelay;
            this.retryDelay = reply.retryDelay;
            reply.retryDelay = retryDelay;
            Message msg = this.msg;
            this.msg = reply.msg;
            reply.msg = msg;
            List<Error> errors = this.errors;
            this.errors = reply.errors;
            reply.errors = errors;
        }
    }

    public Message getMessage() {
        return this.msg;
    }

    public void setMessage(Message msg) {
        this.msg = msg;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasFatalErrors() {
        for (Error error : this.errors) {
            if (error.getCode() < 200000) continue;
            return true;
        }
        return false;
    }

    public Error getError(int i) {
        return this.errors.get(i);
    }

    public int getNumErrors() {
        return this.errors.size();
    }

    public void addError(Error error) {
        this.errors.add(error);
        this.getTrace().trace(1, error.toString());
    }

    public double getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(double retryDelay) {
        this.retryDelay = retryDelay;
    }

    public Stream<Error> getErrors() {
        return this.errors.stream();
    }

    public Set<Integer> getErrorCodes() {
        HashSet<Integer> errorCodes = new HashSet<Integer>();
        for (Error error : this.errors) {
            errorCodes.add(error.getCode());
        }
        return errorCodes;
    }
}

