/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.component.Version;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Values;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.Trace;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCSendAdapter;
import com.yahoo.messagebus.network.rpc.RPCServiceAddress;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingNode;
import com.yahoo.text.Utf8Array;

public abstract class RPCSend
implements MethodHandler,
ReplyHandler,
RequestWaiter,
RPCSendAdapter {
    private RPCNetwork net = null;
    private String clientIdent = "client";
    private String serverIdent = "server";

    protected abstract Method buildMethod();

    protected abstract String getReturnSpec();

    protected abstract Request encodeRequest(Version var1, Route var2, RPCServiceAddress var3, Message var4, long var5, byte[] var7, int var8);

    protected abstract Reply createReply(Values var1, String var2, Trace var3);

    protected abstract Params toParams(Values var1);

    protected abstract void createResponse(Values var1, Reply var2, Version var3, byte[] var4);

    @Override
    public final void attach(RPCNetwork net) {
        this.net = net;
        String prefix = net.getIdentity().getServicePrefix();
        if (prefix != null && prefix.length() > 0) {
            this.serverIdent = this.clientIdent = "'" + prefix + "'";
        }
        net.getSupervisor().addMethod(this.buildMethod());
    }

    @Override
    public final void send(RoutingNode recipient, Version version, byte[] payload, long timeRemaining) {
        SendContext ctx = new SendContext(recipient, timeRemaining);
        RPCServiceAddress address = (RPCServiceAddress)recipient.getServiceAddress();
        Message msg = recipient.getMessage();
        Route route = new Route(recipient.getRoute());
        Hop hop = route.removeHop(0);
        Request req = this.encodeRequest(version, route, address, msg, timeRemaining, payload, ctx.trace.getLevel());
        if (ctx.trace.shouldTrace(4)) {
            ctx.trace.trace(4, "Sending message (version " + version + ") from " + this.clientIdent + " to '" + address.getServiceName() + "' with " + ctx.timeout + " seconds timeout.");
        }
        if (hop.getIgnoreResult()) {
            address.getTarget().getJRTTarget().invokeVoid(req);
            if (ctx.trace.shouldTrace(4)) {
                ctx.trace.trace(4, "Not waiting for a reply from '" + address.getServiceName() + "'.");
            }
            EmptyReply reply = new EmptyReply();
            reply.getTrace().swap(ctx.trace);
            this.net.getOwner().deliverReply(reply, recipient);
        } else {
            req.setContext((Object)ctx);
            address.getTarget().getJRTTarget().invokeAsync(req, ctx.timeout, (RequestWaiter)this);
        }
        req.discardParameters();
    }

    protected final Object decode(Utf8Array protocolName, Version version, byte[] payload) {
        Protocol protocol = this.net.getOwner().getProtocol(protocolName);
        if (protocol != null) {
            Routable routable = protocol.decode(version, payload);
            if (routable != null) {
                if (routable instanceof Reply) {
                    return routable;
                }
                return new Error(200008, "Payload decoded to a reply when expecting a message.");
            }
            return new Error(200008, "Protocol '" + protocol.getName() + "' failed to decode routable.");
        }
        return new Error(200007, "Protocol '" + protocolName + "' is not known by " + this.serverIdent + ".");
    }

    public final void handleRequestDone(Request req) {
        this.net.getExecutor().execute(() -> this.doRequestDone(req));
    }

    private void doRequestDone(Request req) {
        SendContext ctx = (SendContext)req.getContext();
        String serviceName = ((RPCServiceAddress)ctx.recipient.getServiceAddress()).getServiceName();
        Reply reply = null;
        Error error = null;
        if (!req.checkReturnTypes(this.getReturnSpec())) {
            reply = new EmptyReply();
            switch (req.errorCode()) {
                case 103: {
                    error = new Error(200009, "A timeout occured while waiting for '" + serviceName + "' (" + ctx.timeout + " seconds expired); " + req.errorMessage());
                    break;
                }
                case 104: {
                    error = new Error(100003, "A connection error occured for '" + serviceName + "'; " + req.errorMessage());
                    break;
                }
                default: {
                    error = new Error(200006, "A network error occured for '" + serviceName + "'; " + req.errorMessage());
                    break;
                }
            }
        } else {
            reply = this.createReply(req.returnValues(), serviceName, ctx.trace);
        }
        if (ctx.trace.shouldTrace(4)) {
            ctx.trace.trace(4, "Reply (type " + reply.getType() + ") received at " + this.clientIdent + ".");
        }
        reply.getTrace().swap(ctx.trace);
        if (error != null) {
            reply.addError(error);
        }
        this.net.getOwner().deliverReply(reply, ctx.recipient);
    }

    public final void invoke(Request request) {
        request.detach();
        this.net.getExecutor().execute(() -> this.doInvoke(request));
    }

    private void doInvoke(Request request) {
        Params p = this.toParams(request.parameters());
        request.discardParameters();
        Protocol protocol = this.net.getOwner().getProtocol(p.protocolName);
        if (protocol == null) {
            this.replyError(request, p.version, p.traceLevel, new Error(200007, "Protocol '" + p.protocolName + "' is not known by " + this.serverIdent + "."));
            return;
        }
        Routable routable = protocol.decode(p.version, p.payload);
        if (routable == null) {
            this.replyError(request, p.version, p.traceLevel, new Error(200008, "Protocol '" + protocol.getName() + "' failed to decode routable."));
            return;
        }
        if (routable instanceof Reply) {
            this.replyError(request, p.version, p.traceLevel, new Error(200008, "Payload decoded to a reply when expecting a message."));
            return;
        }
        Message msg = (Message)routable;
        if (p.route != null && p.route.length() > 0) {
            msg.setRoute(this.net.getRoute(p.route));
        }
        msg.setContext(new ReplyContext(request, p.version));
        msg.pushHandler(this);
        msg.setRetryEnabled(p.retryEnabled);
        msg.setRetry(p.retry);
        msg.setTimeReceivedNow();
        msg.setTimeRemaining(p.timeRemaining);
        msg.getTrace().setLevel(p.traceLevel);
        if (msg.getTrace().shouldTrace(4)) {
            msg.getTrace().trace(4, "Message (type " + msg.getType() + ") received at " + this.serverIdent + " for session '" + p.session + "'.");
        }
        this.net.getOwner().deliverMessage(msg, p.session);
    }

    @Override
    public final void handleReply(Reply reply) {
        ReplyContext ctx = (ReplyContext)reply.getContext();
        reply.setContext(null);
        if (reply.getTrace().shouldTrace(4)) {
            reply.getTrace().trace(4, "Sending reply (version " + ctx.version + ") from " + this.serverIdent + ".");
        }
        byte[] payload = new byte[]{};
        if (reply.getType() != 0) {
            Protocol protocol = this.net.getOwner().getProtocol((Utf8Array)reply.getProtocol());
            if (protocol != null) {
                payload = protocol.encode(ctx.version, reply);
            }
            if (payload == null || payload.length == 0) {
                reply.addError(new Error(200005, "An error occured while encoding the reply."));
            }
        }
        this.createResponse(ctx.request.returnValues(), reply, ctx.version, payload);
        ctx.request.returnRequest();
    }

    private void replyError(Request request, Version version, int traceLevel, Error err) {
        EmptyReply reply = new EmptyReply();
        reply.setContext(new ReplyContext(request, version));
        reply.getTrace().setLevel(traceLevel);
        reply.addError(err);
        this.handleReply(reply);
    }

    private static class ReplyContext {
        final Request request;
        final Version version;

        public ReplyContext(Request request, Version version) {
            this.request = request;
            this.version = version;
        }
    }

    private static class SendContext {
        final RoutingNode recipient;
        final Trace trace;
        final double timeout;

        SendContext(RoutingNode recipient, long timeRemaining) {
            this.recipient = recipient;
            this.trace = new Trace(recipient.getTrace().getLevel());
            this.timeout = (double)timeRemaining * 0.001;
        }
    }

    protected final class Params {
        Version version;
        String route;
        String session;
        boolean retryEnabled;
        int retry;
        long timeRemaining;
        Utf8Array protocolName;
        byte[] payload;
        int traceLevel;

        protected Params() {
        }
    }
}

