/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.RetryPolicy;
import com.yahoo.messagebus.routing.RoutingNode;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class Resender {
    private final PriorityQueue<Entry> queue = new PriorityQueue();
    private final RetryPolicy retryPolicy;

    public Resender(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public boolean canRetry(int errorCode) {
        return this.retryPolicy.canRetry(errorCode);
    }

    public boolean shouldRetry(Reply reply) {
        int numErrors = reply.getNumErrors();
        if (numErrors == 0) {
            return false;
        }
        for (int i = 0; i < numErrors; ++i) {
            if (this.retryPolicy.canRetry(reply.getError(i).getCode())) continue;
            return false;
        }
        return true;
    }

    public boolean scheduleRetry(RoutingNode node) {
        Message msg = node.getMessage();
        if (!msg.getRetryEnabled()) {
            return false;
        }
        int retry = msg.getRetry() + 1;
        double delay = node.getReply().getRetryDelay();
        if (delay < 0.0) {
            delay = this.retryPolicy.getRetryDelay(retry);
        }
        if ((double)msg.getTimeRemainingNow() * 0.001 - delay <= 0.0) {
            node.addError(200009, "Timeout exceeded by resender, giving up.");
            return false;
        }
        node.prepareForRetry();
        node.getTrace().trace(6, "Message scheduled for retry " + retry + " in " + delay + " seconds.");
        msg.setRetry(retry);
        this.queue.add(new Entry(node, SystemTimer.INSTANCE.milliTime() + (long)(delay * 1000.0)));
        return true;
    }

    public void resendScheduled() {
        if (this.queue.isEmpty()) {
            return;
        }
        LinkedList<RoutingNode> sendList = new LinkedList<RoutingNode>();
        long now = SystemTimer.INSTANCE.milliTime();
        while (!this.queue.isEmpty() && this.queue.peek().time <= now) {
            sendList.add(this.queue.poll().node);
        }
        for (RoutingNode node : sendList) {
            node.getTrace().trace(6, "Resender resending message.");
            node.send();
        }
    }

    public void destroy() {
        while (!this.queue.isEmpty()) {
            this.queue.poll().node.discard();
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        final RoutingNode node;
        final Long time;

        public Entry(RoutingNode node, long time) {
            this.node = node;
            this.time = time;
        }

        @Override
        public int compareTo(Entry rhs) {
            return this.time.compareTo(rhs.time);
        }
    }
}

