/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.concurrent.Timer;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.StaticThrottlePolicy;
import java.util.logging.Logger;

public class RateThrottlingPolicy
extends StaticThrottlePolicy {
    public static final Logger log = Logger.getLogger(RateThrottlingPolicy.class.getName());
    long PERIOD = 1000L;
    double desiredRate;
    double allotted = 0.0;
    long currentPeriod = 0L;
    Timer timer;

    public RateThrottlingPolicy(double desiredRate) {
        this(desiredRate, (Timer)SystemTimer.INSTANCE);
    }

    public RateThrottlingPolicy(double desiredRate, Timer timer) {
        this.desiredRate = desiredRate;
        this.timer = timer;
        this.currentPeriod = timer.milliTime() / this.PERIOD;
    }

    @Override
    public boolean canSend(Message msg, int pendingCount) {
        if (!super.canSend(msg, pendingCount)) {
            return false;
        }
        long period = this.timer.milliTime() / this.PERIOD;
        while (this.currentPeriod < period) {
            if (this.allotted > 0.0) {
                this.allotted = 0.0;
            }
            this.allotted += (double)this.PERIOD * this.desiredRate / 1000.0;
            ++this.currentPeriod;
        }
        if (this.allotted > 0.0) {
            this.allotted -= 1.0;
            return true;
        }
        return false;
    }
}

