/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.network.rpc.OOSClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OOSManager
implements Runnable {
    private boolean disabled;
    private boolean ready;
    private final Supervisor orb;
    private final Mirror mirror;
    private Task task;
    private final String servicePattern;
    private Map<String, OOSClient> clients = Collections.emptyMap();
    private volatile Set<String> oosSet;
    private int slobrokGen = 0;
    private List<Mirror.Entry> services;

    public OOSManager(Supervisor orb, Mirror mirror, String servicePattern) {
        this.orb = orb;
        this.mirror = mirror;
        this.servicePattern = servicePattern;
        this.ready = this.disabled = servicePattern == null || servicePattern.isEmpty();
        if (!this.disabled) {
            this.task = orb.transport().createTask((Runnable)this);
            this.task.scheduleNow();
        }
    }

    @Override
    public void run() {
        boolean changed = this.updateFromSlobrok();
        boolean allOk = this.mirror.ready();
        for (OOSClient client : this.clients.values()) {
            if (client.isChanged()) {
                changed = true;
            }
            if (client.isReady()) continue;
            allOk = false;
        }
        if (changed) {
            LinkedHashSet<String> oos = new LinkedHashSet<String>();
            for (OOSClient client : this.clients.values()) {
                client.dumpState(oos);
            }
            this.oosSet = oos;
        }
        if (allOk && !this.ready) {
            this.ready = true;
        }
        this.task.schedule(this.ready ? 1.0 : 0.1);
    }

    private boolean updateFromSlobrok() {
        if (this.slobrokGen == this.mirror.updates()) {
            return false;
        }
        this.slobrokGen = this.mirror.updates();
        List<Mirror.Entry> newServices = Arrays.asList(this.mirror.lookup(this.servicePattern));
        Collections.sort(newServices, new Comparator<Mirror.Entry>(){

            @Override
            public int compare(Mirror.Entry lhs, Mirror.Entry rhs) {
                return lhs.compareTo(rhs);
            }
        });
        if (newServices.equals(this.services)) {
            return false;
        }
        HashMap<String, OOSClient> newClients = new HashMap<String, OOSClient>();
        for (Mirror.Entry service : newServices) {
            OOSClient client = this.clients.remove(service.getSpec());
            if (client == null) {
                client = new OOSClient(this.orb, new Spec(service.getSpec()));
            }
            newClients.put(service.getSpec(), client);
        }
        for (OOSClient client : this.clients.values()) {
            client.shutdown();
        }
        this.services = newServices;
        this.clients = newClients;
        return true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isOOS(String service) {
        if (this.disabled) {
            return false;
        }
        Set<String> s = this.oosSet;
        if (s == null) {
            return false;
        }
        return s.contains(service);
    }
}

