/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

public final class ErrorCode {
    public static final int NONE = 0;
    public static final int TRANSIENT_ERROR = 100000;
    public static final int SEND_QUEUE_FULL = 100001;
    public static final int NO_ADDRESS_FOR_SERVICE = 100002;
    public static final int CONNECTION_ERROR = 100003;
    public static final int UNKNOWN_SESSION = 100004;
    public static final int SESSION_BUSY = 100005;
    public static final int SEND_ABORTED = 100006;
    public static final int HANDSHAKE_FAILED = 100007;
    public static final int APP_TRANSIENT_ERROR = 150000;
    public static final int FATAL_ERROR = 200000;
    public static final int SEND_QUEUE_CLOSED = 200001;
    public static final int ILLEGAL_ROUTE = 200002;
    public static final int NO_SERVICES_FOR_ROUTE = 200003;
    public static final int SERVICE_OOS = 200004;
    public static final int ENCODE_ERROR = 200005;
    public static final int NETWORK_ERROR = 200006;
    public static final int UNKNOWN_PROTOCOL = 200007;
    public static final int DECODE_ERROR = 200008;
    public static final int TIMEOUT = 200009;
    public static final int INCOMPATIBLE_VERSION = 200010;
    public static final int UNKNOWN_POLICY = 200011;
    public static final int NETWORK_SHUTDOWN = 200012;
    public static final int POLICY_ERROR = 200013;
    public static final int SEQUENCE_ERROR = 200014;
    public static final int APP_FATAL_ERROR = 250000;
    public static final int ERROR_LIMIT = 300000;

    public static String getName(int error) {
        switch (error) {
            case 250000: {
                return "APP_FATAL_ERROR";
            }
            case 150000: {
                return "APP_TRANSIENT_ERROR";
            }
            case 100003: {
                return "CONNECTION_ERROR";
            }
            case 200008: {
                return "DECODE_ERROR";
            }
            case 200005: {
                return "ENCODE_ERROR";
            }
            case 200000: {
                return "FATAL_ERROR";
            }
            case 100007: {
                return "HANDSHAKE_FAILED";
            }
            case 200002: {
                return "ILLEGAL_ROUTE";
            }
            case 200010: {
                return "INCOMPATIBLE_VERSION";
            }
            case 200006: {
                return "NETWORK_ERROR";
            }
            case 200012: {
                return "NETWORK_SHUTDOWN";
            }
            case 100002: {
                return "NO_ADDRESS_FOR_SERVICE";
            }
            case 200003: {
                return "NO_SERVICES_FOR_ROUTE";
            }
            case 0: {
                return "NONE";
            }
            case 200013: {
                return "POLICY_ERROR";
            }
            case 100006: {
                return "SEND_ABORTED";
            }
            case 200001: {
                return "SEND_QUEUE_CLOSED";
            }
            case 100001: {
                return "SEND_QUEUE_FULL";
            }
            case 200014: {
                return "SEQUENCE_ERROR";
            }
            case 200004: {
                return "SERVICE_OOS";
            }
            case 100005: {
                return "SESSION_BUSY";
            }
            case 200009: {
                return "TIMEOUT";
            }
            case 100000: {
                return "TRANSIENT_ERROR";
            }
            case 200011: {
                return "UNKNOWN_POLICY";
            }
            case 200007: {
                return "UNKNOWN_PROTOCOL";
            }
            case 100004: {
                return "UNKNOWN_SESSION";
            }
        }
        return "UNKNOWN(" + error + ")";
    }
}

