/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc.test;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.slobrok.api.Register;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.jrt.slobrok.server.Slobrok;
import com.yahoo.messagebus.network.rpc.test.OOSState;
import java.util.ArrayList;
import java.util.List;

public class OOSServer {
    private int getCnt = 1;
    private List<String> state = new ArrayList<String>();
    private Supervisor orb = new Supervisor(new Transport());
    private Register register;
    private Acceptor listener;

    public OOSServer(Slobrok slobrok, String service, OOSState state) {
        this.orb.addMethod(new Method("fleet.getOOSList", "ii", "Si", new MethodHandler(){

            public void invoke(Request request) {
                OOSServer.this.rpc_poll(request);
            }
        }).methodDesc("Fetch OOS information.").paramDesc(0, "gencnt", "Generation already known by client.").paramDesc(1, "timeout", "How many milliseconds to wait for changes before returning if nothing has changed (max=10000).").returnDesc(0, "names", "List of services that are OOS (empty if generation has not changed).").returnDesc(1, "newgen", "Generation of the returned list."));
        try {
            this.listener = this.orb.listen(new Spec(0));
        }
        catch (ListenFailedException e) {
            this.orb.transport().shutdown().join();
            throw new RuntimeException(e);
        }
        SlobrokList slist = new SlobrokList();
        slist.setup(new String[]{new Spec("localhost", slobrok.port()).toString()});
        this.register = new Register(this.orb, slist, "localhost", this.listener.port());
        this.register.registerName(service);
        this.setState(state);
    }

    public void shutdown() {
        this.register.shutdown();
        this.listener.shutdown().join();
        this.orb.transport().shutdown().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(OOSState state) {
        ArrayList<String> newState = new ArrayList<String>();
        for (String service : state.getServices()) {
            if (!state.isOOS(service)) continue;
            newState.add(service);
        }
        OOSServer oOSServer = this;
        synchronized (oOSServer) {
            this.state = newState;
            if (++this.getCnt == 0) {
                this.getCnt = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rpc_poll(Request request) {
        OOSServer oOSServer = this;
        synchronized (oOSServer) {
            request.returnValues().add((Value)new StringArray(this.state.toArray(new String[this.state.size()]))).add((Value)new Int32Value(this.getCnt));
        }
    }

    public int getPort() {
        return this.listener.port();
    }
}

