/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Task;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class OOSClient
implements Runnable,
RequestWaiter {
    private Supervisor orb;
    private Target target = null;
    private Request request = null;
    private boolean requestDone = false;
    private Spec spec;
    private Task task;
    private List<String> oosList = new ArrayList<String>();
    private int requestGen = 0;
    private int listGen = 0;
    private int dumpGen = 0;
    private boolean shutdown = false;

    public OOSClient(Supervisor orb, Spec spec) {
        this.orb = orb;
        this.spec = spec;
        this.task = this.orb.transport().createTask((Runnable)this);
        this.task.scheduleNow();
    }

    private void handleReply() {
        if (!this.request.checkReturnTypes("Si")) {
            if (this.target != null) {
                this.target.close();
                this.target = null;
            }
            this.task.schedule(1.0);
            return;
        }
        Values ret = this.request.returnValues();
        int retGen = ret.get(1).asInt32();
        if (this.requestGen != retGen) {
            ArrayList<String> oos = new ArrayList<String>();
            oos.addAll(Arrays.asList(ret.get(0).asStringArray()));
            this.oosList = oos;
            this.requestGen = retGen;
            this.listGen = retGen;
        }
        this.task.schedule(0.1);
    }

    private void handleConnect() {
        if (this.target == null) {
            this.target = this.orb.connect(this.spec);
            this.requestGen = 0;
        }
    }

    private void handleInvoke() {
        if (this.target == null) {
            throw new IllegalStateException("Attempting to invoke a request on a null target.");
        }
        this.request = new Request("fleet.getOOSList");
        this.request.parameters().add((Value)new Int32Value(this.requestGen));
        this.request.parameters().add((Value)new Int32Value(60000));
        this.target.invokeAsync(this.request, 70.0, (RequestWaiter)this);
    }

    @Override
    public void run() {
        if (this.shutdown) {
            this.task.kill();
            if (this.target != null) {
                this.target.close();
            }
        } else if (this.requestDone) {
            this.requestDone = false;
            this.handleReply();
        } else {
            this.handleConnect();
            this.handleInvoke();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.task.scheduleNow();
    }

    public void handleRequestDone(Request request) {
        if (request != this.request || this.requestDone) {
            throw new IllegalStateException("Multiple invocations of RequestDone().");
        }
        this.requestDone = true;
        this.task.scheduleNow();
    }

    public Spec getSpec() {
        return this.spec;
    }

    public boolean isChanged() {
        return this.listGen != this.dumpGen;
    }

    public boolean isReady() {
        return this.listGen != 0;
    }

    public void dumpState(Set<String> dst) {
        dst.addAll(this.oosList);
        this.dumpGen = this.listGen;
    }
}

