/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Messenger
implements Runnable {
    private static final Logger log = Logger.getLogger(Messenger.class.getName());
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final List<Task> children = new ArrayList<Task>();
    private final Queue<Task> queue = new ArrayDeque<Task>();
    private final Thread thread = new Thread((Runnable)this, "Messenger");

    public Messenger() {
        this.thread.setDaemon(true);
    }

    public void addRecurrentTask(Task task) {
        this.children.add(task);
    }

    public void start() {
        this.thread.start();
    }

    public void deliverMessage(Message msg, MessageHandler handler) {
        this.enqueue(new MessageTask(msg, handler));
    }

    public void deliverReply(Reply reply, ReplyHandler handler) {
        this.enqueue(new ReplyTask(reply, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Task task) {
        if (this.destroyed.get()) {
            task.destroy();
            return;
        }
        Messenger messenger = this;
        synchronized (messenger) {
            this.queue.offer(task);
            if (this.queue.size() == 1) {
                this.notify();
            }
        }
    }

    public void sync() {
        if (Thread.currentThread() == this.thread) {
            return;
        }
        SyncTask task = new SyncTask();
        this.enqueue(task);
        task.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        boolean done = false;
        this.enqueue(Terminate.INSTANCE);
        if (!this.destroyed.getAndSet(true)) {
            try {
                Messenger messenger = this;
                synchronized (messenger) {
                    while (!this.queue.isEmpty()) {
                        this.wait();
                    }
                }
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            done = true;
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block12: while (true) {
            task = null;
            var2_2 = this;
            synchronized (var2_2) {
                if (this.queue.isEmpty()) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                if (this.queue.size() > 0) {
                    task = this.queue.poll();
                }
            }
            if (task == Terminate.INSTANCE) break;
            if (task != null) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    Messenger.log.log((Level)LogLevel.ERROR, "An exception was thrown while running " + task.getClass().getName(), e);
                }
                try {
                    task.destroy();
                }
                catch (Exception e) {
                    Messenger.log.warning("An exception was thrown while destroying " + task.getClass().getName() + ": " + e.toString());
                    Messenger.log.warning("Someone, somewhere might have to wait indefinetly for something.");
                }
            }
            e = this.children.iterator();
            while (true) {
                if (e.hasNext()) ** break;
                continue block12;
                child = e.next();
                child.run();
            }
            break;
        }
        for (Task child : this.children) {
            child.destroy();
        }
        var1_1 = this;
        synchronized (var1_1) {
            while (!this.queue.isEmpty()) {
                task = this.queue.poll();
                task.destroy();
            }
            this.notify();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.destroy()) {
                log.log(LogLevel.WARNING, "Messenger destroyed by finalizer, please review application shutdown logic.");
            }
        }
        finally {
            super.finalize();
        }
    }

    private static class Terminate
    implements Task {
        static final Terminate INSTANCE = new Terminate();

        private Terminate() {
        }

        @Override
        public void run() {
        }

        @Override
        public void destroy() {
        }
    }

    private static class SyncTask
    implements Task {
        final CountDownLatch latch = new CountDownLatch(1);

        private SyncTask() {
        }

        @Override
        public void run() {
        }

        @Override
        public void destroy() {
            this.latch.countDown();
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class ReplyTask
    implements Task {
        final ReplyHandler handler;
        Reply reply;

        ReplyTask(Reply reply, ReplyHandler handler) {
            this.reply = reply;
            this.handler = handler;
        }

        @Override
        public void run() {
            Reply reply = this.reply;
            this.reply = null;
            this.handler.handleReply(reply);
        }

        @Override
        public void destroy() {
            if (this.reply != null) {
                this.reply.discard();
            }
        }
    }

    private static class MessageTask
    implements Task {
        final MessageHandler handler;
        Message msg;

        MessageTask(Message msg, MessageHandler handler) {
            this.msg = msg;
            this.handler = handler;
        }

        @Override
        public void run() {
            Message msg = this.msg;
            this.msg = null;
            this.handler.handleMessage(msg);
        }

        @Override
        public void destroy() {
            if (this.msg != null) {
                this.msg.discard();
            }
        }
    }

    public static interface Task {
        public void run();

        public void destroy();
    }
}

