/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.mcp;

import ai.vespa.mcp.JdiscMcpServer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.component.chain.Chain;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.schema.Field;
import com.yahoo.search.schema.FieldInfo;
import com.yahoo.search.schema.FieldSet;
import com.yahoo.search.schema.Schema;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.ExecutionFactory;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class McpTools {
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(McpTools.class.getName());
    private final ExecutionFactory executionFactory;
    private final Chain<Searcher> searchChain;
    private final SchemaInfo schemaInfo;
    private final CompiledQueryProfileRegistry queryProfileRegistry;
    private static final String VESPA_DOCS_BASE_URL = "https://docs.vespa.ai";
    private static final String VESPA_SEARCH_API_BASE_URL = "https://api.search.vespa.ai/search/";

    public McpTools(ExecutionFactory executionFactory, CompiledQueryProfileRegistry queryProfileRegistry) {
        this.executionFactory = executionFactory;
        this.queryProfileRegistry = queryProfileRegistry;
        this.searchChain = executionFactory.searchChainRegistry().getChain("native");
        this.schemaInfo = executionFactory.schemaInfo();
    }

    private static <T> T safeMapCast(Object obj) {
        return (T)(obj instanceof Map ? obj : null);
    }

    private static <T> T safeListCast(Object obj) {
        return (T)(obj instanceof List ? obj : null);
    }

    private Map<String, Object> error(String message, Exception e) {
        logger.log(Level.SEVERE, message, e);
        return Map.of("error", message + ": " + e.getMessage());
    }

    public Map<String, Object> getDocumentation(String userinput) {
        Map<String, String> params = Map.of("yql", "select * from doc where userInput(@userinput)", "userinput", userinput);
        StringBuilder urlBuilder = new StringBuilder(VESPA_SEARCH_API_BASE_URL);
        urlBuilder.append("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            urlBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
            urlBuilder.append("=");
            urlBuilder.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            urlBuilder.append("&");
        }
        urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        String fullUrl = urlBuilder.toString();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(fullUrl)).header("Accept", "application/json").GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            Map jsonResponse = (Map)OBJECT_MAPPER.readValue(response.body(), (TypeReference)typeRef);
            Map root = (Map)McpTools.safeMapCast(jsonResponse.get("root"));
            List children = root != null ? (List)McpTools.safeListCast(root.get("children")) : null;
            LinkedHashMap<String, CallSite> sources = new LinkedHashMap<String, CallSite>();
            if (children != null) {
                for (Map child : children) {
                    Map fields = (Map)McpTools.safeMapCast(child.get("fields"));
                    if (fields == null) continue;
                    String title = (String)fields.get("title");
                    String path = (String)fields.get("path");
                    if (title == null || path == null) continue;
                    String url = VESPA_DOCS_BASE_URL + path;
                    sources.put(title, (CallSite)((Object)url));
                }
            }
            return Map.of("response", jsonResponse, "sources", sources);
        }
        catch (Exception e) {
            return this.error("Error fetching documentation", e);
        }
    }

    public Map<String, Object> getSchemas() {
        LinkedList<String> allSchemaNames = new LinkedList<String>(this.schemaInfo.schemas().keySet());
        return this.getSchemas(allSchemaNames);
    }

    public Map<String, Object> getSchemas(List<String> schemaNames) {
        logger.info("Trying to retrieve " + schemaNames.size() + " schemas");
        try {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map schemaMap = this.schemaInfo.schemas();
            int retrievedCount = 0;
            for (String schemaName : schemaNames) {
                Schema schema = (Schema)schemaMap.get(schemaName);
                if (schema == null) {
                    result.put(schemaName, "Schema not found");
                    continue;
                }
                Map<String, Object> schemaDetails = this.schemaDetails(schema);
                result.put(schemaName, schemaDetails);
                ++retrievedCount;
            }
            logger.info("Retrieved " + retrievedCount + " schemas");
            return result;
        }
        catch (Exception e) {
            return this.error("Error fetching schemas", e);
        }
    }

    private Map<String, Object> fieldsOrFieldsetsInfo(Map<String, ? extends FieldInfo> fields) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        fields.forEach((name, f) -> {
            LinkedHashMap<String, Object> fieldDetails = new LinkedHashMap<String, Object>();
            fieldDetails.put("name", f.name());
            fieldDetails.put("type", f.type().toString());
            fieldDetails.put("isIndex", f.isIndex());
            fieldDetails.put("isAttribute", f.isAttribute());
            fieldDetails.put(f instanceof Field ? "aliases" : "fieldNames", f instanceof Field ? ((Field)f).aliases() : ((FieldSet)f).fieldNames());
            result.put((String)name, fieldDetails);
        });
        return result;
    }

    private Map<String, Object> schemaDetails(Schema schema) {
        try {
            LinkedHashMap<String, Object> schemaDetails = new LinkedHashMap<String, Object>();
            schemaDetails.put("name", schema.name());
            Map<String, Object> fieldsInfo = this.fieldsOrFieldsetsInfo(schema.fields());
            schemaDetails.put("fields", fieldsInfo);
            Map<String, Object> fieldSetsInfo = this.fieldsOrFieldsetsInfo(schema.fieldSets());
            schemaDetails.put("fieldSets", fieldSetsInfo);
            LinkedHashMap rankProfilesInfo = new LinkedHashMap();
            schema.rankProfiles().forEach((profileName, profile) -> {
                LinkedHashMap inputsInfo = new LinkedHashMap();
                profile.inputs().forEach((inputName, inputType) -> inputsInfo.put(inputName, inputType.toString()));
                LinkedHashMap<String, Object> profileDetails = new LinkedHashMap<String, Object>();
                profileDetails.put("name", profile.name());
                profileDetails.put("hasSummaryFeatures", profile.hasSummaryFeatures());
                profileDetails.put("hasRankFeatures", profile.hasRankFeatures());
                profileDetails.put("useSignificanceModel", profile.useSignificanceModel());
                profileDetails.put("inputs", inputsInfo);
                rankProfilesInfo.put(profileName, profileDetails);
            });
            schemaDetails.put("rankProfiles", rankProfilesInfo);
            LinkedHashMap documentSummariesInfo = new LinkedHashMap();
            schema.documentSummaries().forEach((summaryName, summary) -> {
                LinkedHashMap<String, Object> summaryDetails = new LinkedHashMap<String, Object>();
                summaryDetails.put("name", summary.name());
                summaryDetails.put("isDynamic", summary.isDynamic());
                LinkedHashMap summaryFieldsInfo = new LinkedHashMap();
                summary.fields().forEach((fieldName, field) -> {
                    LinkedHashMap<String, String> fieldDetails = new LinkedHashMap<String, String>();
                    fieldDetails.put("name", field.name());
                    fieldDetails.put("type", field.type().asString());
                    summaryFieldsInfo.put(fieldName, fieldDetails);
                });
                summaryDetails.put("fields", summaryFieldsInfo);
                documentSummariesInfo.put(summaryName, summaryDetails);
            });
            schemaDetails.put("documentSummaries", documentSummariesInfo);
            return schemaDetails;
        }
        catch (Exception e) {
            return this.error("Error converting schema to map", e);
        }
    }

    public Map<String, Object> executeQuery(String yql, String queryProfileName, Map<String, String> params) {
        try {
            if (this.searchChain == null) {
                return Map.of("error", "No search chain available");
            }
            Query query = new Query.Builder().setRequestMap(params != null ? params : Map.of()).setQueryProfile(this.queryProfileRegistry.findQueryProfile(queryProfileName)).setSchemaInfo(this.schemaInfo).build();
            query.getModel().setQueryString(yql);
            query.getModel().setType(Query.Type.YQL);
            logger.info("Trying to execute query: yql = " + yql + ", params = " + String.valueOf(params));
            Execution execution = this.executionFactory.newExecution(this.searchChain);
            Result result = execution.search(query);
            execution.fill(result);
            logger.info("Query executed successfully: " + result.getTotalHitCount() + " total hits found.");
            return this.resultToMap(result);
        }
        catch (Exception e) {
            return this.error("Error executing query", e);
        }
    }

    private Map<String, Object> resultToMap(Result result) {
        try {
            LinkedHashMap<String, Object> rootWrapper = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
            rootWrapper.put("root", root);
            root.put("id", result.hits().getId() != null ? result.hits().getId().toString() : null);
            root.put("relevance", result.hits().getRelevance() != null ? Double.valueOf(result.hits().getRelevance().getScore()) : null);
            root.put("fields", Map.of("totalCount", result.getTotalHitCount()));
            Coverage cov = result.getCoverage(false);
            if (cov != null) {
                LinkedHashMap<String, Serializable> coverage = new LinkedHashMap<String, Serializable>();
                coverage.put("coverage", Integer.valueOf(cov.getResultPercentage()));
                coverage.put("documents", Long.valueOf(cov.getDocs()));
                coverage.put("full", Boolean.valueOf(cov.getFull()));
                coverage.put("nodes", Integer.valueOf(cov.getNodes()));
                coverage.put("results", Integer.valueOf(cov.getResultSets()));
                coverage.put("resultsFull", Integer.valueOf(cov.getFullResultSets()));
                root.put("coverage", coverage);
            }
            LinkedList<Map<String, Object>> children = new LinkedList<Map<String, Object>>();
            Iterator hitIterator = result.hits().deepIterator();
            while (hitIterator.hasNext()) {
                Hit hit = (Hit)hitIterator.next();
                if (hit.isMeta()) continue;
                Map<String, Object> child = this.hitToMap(hit);
                children.add(child);
            }
            root.put("children", children);
            return rootWrapper;
        }
        catch (Exception e) {
            return this.error("JSON conversion failed", e);
        }
    }

    private Map<String, Object> hitToMap(Hit hit) {
        LinkedHashMap<String, Object> hitMap = new LinkedHashMap<String, Object>();
        hitMap.put("id", hit.getId() != null ? hit.getId().toString() : null);
        hitMap.put("relevance", hit.getRelevance() != null ? Double.valueOf(hit.getRelevance().getScore()) : null);
        hitMap.put("source", hit.getSource() != null ? hit.getSource() : null);
        LinkedHashMap fields = new LinkedHashMap();
        hit.forEachField((fieldName, fieldValue) -> fields.put(fieldName, this.convertFieldValue(fieldValue)));
        hitMap.put("fields", fields);
        return hitMap;
    }

    private Object convertFieldValue(Object fieldValue) {
        try {
            if (fieldValue == null) {
                return null;
            }
            if (fieldValue instanceof Tensor) {
                Tensor tensor = (Tensor)fieldValue;
                LinkedHashMap<String, Object> tensorNode = new LinkedHashMap<String, Object>();
                tensorNode.put("type", tensor.type().toString());
                LinkedHashMap cells = new LinkedHashMap();
                for (Map.Entry entry : tensor.cells().entrySet()) {
                    cells.put(((TensorAddress)entry.getKey()).toString(), entry.getValue());
                }
                tensorNode.put("cells", cells);
                return tensorNode;
            }
            if (fieldValue instanceof String || fieldValue instanceof Number || fieldValue instanceof Boolean || fieldValue instanceof Collection || fieldValue instanceof Map) {
                return fieldValue;
            }
            return fieldValue.toString();
        }
        catch (Exception e) {
            return fieldValue.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readQueryExamples() {
        try (InputStream inputStream = JdiscMcpServer.class.getClassLoader().getResourceAsStream("queryExamples.txt");){
            if (inputStream == null) {
                logger.log(Level.SEVERE, "Query examples resource not found");
                String string2 = "Query examples resource not found";
                return string2;
            }
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to read query examples resource: " + e.getMessage(), e);
            return "Error reading query examples: " + e.getMessage();
        }
    }
}

