/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.mcp;

import ai.vespa.mcp.McpHttpTransport;
import ai.vespa.mcp.McpTools;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class JdiscMcpServer
implements Closeable {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = Logger.getLogger(JdiscMcpServer.class.getName());
    private final McpHttpTransport transport = new McpHttpTransport();
    private final McpTools vespaTools;
    private final List<McpStatelessServerFeatures.SyncToolSpecification> toolSpecs;

    public JdiscMcpServer(McpTools vespaTools) {
        this.vespaTools = vespaTools;
        this.toolSpecs = List.of(this.getDocumentationTool(), this.getSchemasTool(), this.executeQueryTool(), this.readQueryExamplesTool());
        McpStatelessServerFeatures.SyncResourceSpecification queryExamples = this.queryExamplesResource();
        McpStatelessServerFeatures.SyncPromptSpecification listTools = this.listToolsPrompt();
        logger.info("Starting Vespa MCP server...");
        McpServer.sync((McpStatelessServerTransport)this.transport).serverInfo("VespaMCP", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).resources(Boolean.valueOf(true), Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).logging().build()).tools(this.toolSpecs).resources(new McpStatelessServerFeatures.SyncResourceSpecification[]{queryExamples}).prompts(new McpStatelessServerFeatures.SyncPromptSpecification[]{listTools}).build();
        logger.info("Vespa MCP server started");
    }

    public McpHttpTransport getTransport() {
        return this.transport;
    }

    private String getRequiredString(Map<String, Object> args, String required) {
        String str;
        Object val = args.get(required);
        if (!(val instanceof String) || (str = (String)val).isBlank()) {
            throw new IllegalArgumentException(required + " is required and must be a non-empty string");
        }
        return str;
    }

    private String toJson(Object obj) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            return "Error formatting to JSON: " + e.getMessage();
        }
    }

    private McpStatelessServerFeatures.SyncToolSpecification getDocumentationTool() {
        String schema = "    {\n        \"type\": \"object\",\n        \"properties\": {\n            \"userinput\": {\n                \"type\": \"string\",\n                \"description\": \"Natural language query to search Vespa documentation.\",\n                \"minLength\": 1\n            }\n        },\n        \"required\": [\"userinput\"],\n        \"additionalProperties\": false,\n        \"description\": \"Search Vespa's official documentation using natural language queries.\"\n    }\n";
        McpSchema.Tool toolDef = McpSchema.Tool.builder().name("getDocumentation").description("Search Vespa's official documentation using hybrid search.\n\nThis tool queries the Vespa documentation at docs.vespa.ai using natural language input.\nIt returns relevant documentation sections with titles, content excerpts, and direct URLs to the full articles.\n\nUse this tool to:\n- Find documentation on Vespa features, configuration, and APIs\n- Understand Vespa concepts like schemas, ranking, indexing, and query language\n- Access troubleshooting guides and performance tuning advice\n\nThe response includes:\n- \"sources\": A map of document titles to their full URLs for easy reference\n- \"response\": The complete response based on the search query\n\nAlways cite specific documentation URLs when providing answers based on this tool's results.\nInclude URLs inline where information is used, not grouped at the end.\n").inputSchema(schema).build();
        return McpStatelessServerFeatures.SyncToolSpecification.builder().tool(toolDef).callHandler((context, request) -> {
            try {
                String userinput;
                try {
                    userinput = this.getRequiredString(request.arguments(), "userinput");
                }
                catch (IllegalArgumentException e) {
                    return new McpSchema.CallToolResult("{\"error\": \"" + e.getMessage() + "\"}", Boolean.valueOf(true));
                }
                Map<String, Object> documentation = this.vespaTools.getDocumentation(userinput.trim());
                String result = this.toJson(documentation);
                return new McpSchema.CallToolResult(result, Boolean.valueOf(false));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Documentation search failed", e);
                return new McpSchema.CallToolResult("{\"error\": \"Documentation search failed: " + e.getMessage() + "\"}", Boolean.valueOf(true));
            }
        }).build();
    }

    private McpStatelessServerFeatures.SyncToolSpecification getSchemasTool() {
        String schema = "    {\n        \"type\": \"object\",\n        \"properties\": {\n            \"schemaNames\": {\n                \"type\": \"array\",\n                \"items\": { \"type\": \"string\" },\n                \"description\": \"Optional list of schema names to fetch. If omitted, all schemas are returned.\"\n            }\n        },\n        \"required\": [],\n        \"additionalProperties\": false,\n        \"description\": \"Returns schema information for all or selected schemas in the Vespa application.\"\n    }\n";
        McpSchema.Tool defTool = McpSchema.Tool.builder().name("getSchemas").description("Retrieve schema information from the current Vespa application.\n\nUsage:\n- If no parameters are provided, all schemas are returned.\n- If 'schemaNames' is provided (as a list), only the specified schemas are returned.\n\nUse this tool to:\n- Understand the data structure and available fields for querying\n- Check field types and indexing configurations\n- Discover available rank profiles and their parameters\n- Plan queries based on the actual schema configuration\n\nThe response provides a complete map of schema information to guide query construction and help understand what data is available for search and ranking.\n").inputSchema(schema).build();
        return McpStatelessServerFeatures.SyncToolSpecification.builder().tool(defTool).callHandler((context, request) -> {
            try {
                Map<String, Object> schemas;
                Map arguments = request.arguments();
                if (arguments != null && arguments.containsKey("schemaNames")) {
                    Object schemaNamesObj = arguments.get("schemaNames");
                    if (!(schemaNamesObj instanceof List)) return new McpSchema.CallToolResult("{\"error\": \"Invalid schemaNames parameter, expected an array of schema names\"}", Boolean.valueOf(true));
                    List schemaNames = (List)schemaNamesObj;
                    schemas = this.vespaTools.getSchemas(schemaNames);
                } else {
                    schemas = this.vespaTools.getSchemas();
                }
                String result = this.toJson(schemas);
                return new McpSchema.CallToolResult(result, Boolean.valueOf(false));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Schema retrieval failed", e);
                return new McpSchema.CallToolResult("{\"error\": \"Schema retrieval failed: " + e.getMessage() + "\"}", Boolean.valueOf(true));
            }
        }).build();
    }

    private McpStatelessServerFeatures.SyncToolSpecification executeQueryTool() {
        String schema = "    {\n        \"type\": \"object\",\n        \"properties\": {\n            \"yql\": {\n                \"type\": \"string\",\n                \"description\": \"YQL (Vespa Query Language) query string\",\n                \"minLength\": 1\n            },\n            \"queryProfileName\": {\n                \"type\": \"string\",\n                \"description\": \"Name of the query profile to use\",\n                \"minLength\": 1\n            },\n            \"parameters\": {\n                \"type\": \"object\",\n                \"description\": \"Optional query parameters (hits, ranking, timeout, etc.)\",\n                \"additionalProperties\": true\n            }\n        },\n        \"required\": [\"yql\"],\n        \"additionalProperties\": false,\n        \"description\": \"Execute YQL (Vespa Query Language) queries against the Vespa application.\"\n    }\n";
        McpSchema.Tool defTool = McpSchema.Tool.builder().name("executeQuery").description("Execute YQL (Vespa Query Language) queries against the Vespa application.\n\nBefore using this tool, ensure you have:\n- Inspected available schemas using getSchemas tool\n- Understood Vespa's query language using getDocumentation tool\n- Read example queries using queryExamples resource\n\nThis tool runs queries using Vespa's YQL syntax and returns structured search results.\nIt supports the full range of Vespa query capabilities including text search, filtering,\ngrouping, sorting, and other features.\nUse 'sources' parameter to restrict search to specific schemas:\n- {\"sources\": \"source1\"} - search only news schema\n- {\"sources\": \"source1,source2\"} - search multiple schemas\n- Omit sources to search all schemas\n\nRetrieves the response from the Vespa application based on the provided YQL query.\n").inputSchema(schema).build();
        return McpStatelessServerFeatures.SyncToolSpecification.builder().tool(defTool).callHandler((context, request) -> {
            try {
                Map arguments = request.arguments();
                if (arguments == null) {
                    return new McpSchema.CallToolResult("{\"error\": \"No arguments provided\"}", Boolean.valueOf(true));
                }
                String yql = (String)arguments.get("yql");
                if (yql == null || yql.trim().isEmpty()) {
                    return new McpSchema.CallToolResult("{\"error\": \"yql parameter is required and cannot be empty\"}", Boolean.valueOf(true));
                }
                String queryProfileName = (String)arguments.get("queryProfileName");
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                Object parametersObj = arguments.get("parameters");
                if (parametersObj instanceof Map) {
                    Map inputParams = (Map)parametersObj;
                    for (Map.Entry entry : inputParams.entrySet()) {
                        if (entry.getKey() == null || entry.getValue() == null) continue;
                        params.put((String)entry.getKey(), entry.getValue().toString());
                    }
                }
                String result = this.toJson(this.vespaTools.executeQuery(yql, queryProfileName, params));
                return new McpSchema.CallToolResult(result, Boolean.valueOf(false));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Query execution failed", e);
                return new McpSchema.CallToolResult("{\"error\": \"Query execution failed: " + e.getMessage() + "\"}", Boolean.valueOf(true));
            }
        }).build();
    }

    private McpStatelessServerFeatures.SyncToolSpecification readQueryExamplesTool() {
        String schema = "    {\n        \"type\": \"object\",\n        \"properties\": {},\n        \"required\": [],\n        \"additionalProperties\": false,\n        \"description\": \"Retrieves example queries that can be used with the executeQuery tool.\"\n    }\n";
        McpSchema.Tool toolDef = McpSchema.Tool.builder().name("readQueryExamples").description("Retrieves example queries that can be used with the executeQuery tool.\nOnly invoke this tool if you are constructing a query, and have not already read the queryExamples resource.\n\nThis tool provides a set of predefined Vespa queries that demonstrate how to use the executeQuery tool effectively.\nThe examples cover various use cases and can be used as a starting point for constructing your own queries.\n").inputSchema(schema).build();
        return McpStatelessServerFeatures.SyncToolSpecification.builder().tool(toolDef).callHandler((context, request) -> new McpSchema.CallToolResult(this.toJson(this.vespaTools.readQueryExamples()), Boolean.valueOf(false))).build();
    }

    private McpStatelessServerFeatures.SyncResourceSpecification queryExamplesResource() {
        McpSchema.Resource defResource = McpSchema.Resource.builder().name("queryExamples").uri("/resources/queryExamples").description("This resource provides example YQL queries that can be used with the executeQuery tool.\n\nIt uses a Vespa tutorial application to demonstrate various queries and how to translate the command-line query to how the MCP tool can be used.\nMost likely the Vespa application will be different so the example queries are meant for demonstration purposes only.\n\nFor other queries use the getDocumentation tool to find relevant documentation on Vespa's query language.\n").mimeType("text/plain").build();
        return new McpStatelessServerFeatures.SyncResourceSpecification(defResource, (context, request) -> {
            McpSchema.ReadResourceResult readResourceResult;
            block9: {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("queryExamples.txt");
                try {
                    if (inputStream == null) {
                        throw new FileNotFoundException("Resource not found: queryExamples.txt");
                    }
                    String examples = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    readResourceResult = new McpSchema.ReadResourceResult(List.of(new McpSchema.TextResourceContents("/resources/queryExamples", "text/plain", examples)));
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to retrieve query examples", e);
                        return new McpSchema.ReadResourceResult(List.of(new McpSchema.TextResourceContents("/resources/queryExamples", "application/json", "{\"error\": \"Failed to retrieve query examples: " + e.getMessage() + "\"}")));
                    }
                }
                inputStream.close();
            }
            return readResourceResult;
        });
    }

    private McpStatelessServerFeatures.SyncPromptSpecification listToolsPrompt() {
        return new McpStatelessServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("listTools", "List all available tools of the Vespa MCP server and their descriptions.", List.of()), (context, request) -> {
            try {
                StringBuilder summary = new StringBuilder();
                summary.append("Summarize the available tools in the Vespa MCP server:\n\n");
                for (McpStatelessServerFeatures.SyncToolSpecification spec : this.toolSpecs) {
                    summary.append(spec.tool().name()).append(" - ").append(spec.tool().description()).append("\n");
                }
                List<McpSchema.PromptMessage> messages = List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent(summary.toString())));
                return new McpSchema.GetPromptResult("Tools available in Vespa MCP server", messages);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to generate list of tools", e);
                return new McpSchema.GetPromptResult("Error generating list of tools", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Error generating list of tools: " + e.getMessage()))));
            }
        });
    }

    @Override
    public void close() {
        try {
            this.transport.closeGracefully().block();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error closing MCP transport", e);
        }
    }
}

