/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import io.modelcontextprotocol.server.DefaultMcpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class McpHttpTransport
implements McpStatelessServerTransport {
    private static final Logger logger = Logger.getLogger(McpHttpTransport.class.getName());
    private final ObjectMapper mapper = new ObjectMapper();
    private McpStatelessServerHandler mcpHandler;
    private final McpTransportContextExtractor<HttpRequest> contextExtractor = (request, context) -> context;
    private volatile boolean isClosing = false;

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
    }

    public Mono<Void> closeGracefully() {
        return Mono.fromRunnable(() -> {
            this.isClosing = true;
        });
    }

    private HttpResponse createHttpResponse(int statusCode, final String jsonText) {
        return new HttpResponse(statusCode){

            public void render(OutputStream outputStream) throws IOException {
                if (jsonText != null) {
                    this.headers().add("Content-Type", "application/json");
                    this.headers().add("Access-Control-Allow-Origin", "*");
                    outputStream.write(jsonText.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                }
            }
        };
    }

    public HttpResponse createErrorResponse(int statusCode, String errorMsg, Exception e) {
        if (e != null) {
            logger.log(Level.SEVERE, errorMsg, e);
        }
        return this.createHttpResponse(statusCode, errorMsg);
    }

    public HttpResponse handleGet(HttpRequest request) {
        return this.createHttpResponse(405, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse handlePost(HttpRequest request, byte[] requestBody) {
        accept = request.getHeader("Accept");
        if (accept == null || !accept.contains("application/json")) {
            return this.createErrorResponse(400, "application/json must be in the Accept header", null);
        }
        if (this.isClosing) {
            McpHttpTransport.logger.log(Level.SEVERE, "POST request received while transport is closing");
            return this.createErrorResponse(503, "Transport is closing, no further requests will be accepted", null);
        }
        context = this.contextExtractor.extract((Object)request, (McpTransportContext)new DefaultMcpTransportContext());
        try {
            block12: {
                message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.mapper, (String)new String(requestBody, StandardCharsets.UTF_8));
                if (!(message instanceof McpSchema.JSONRPCRequest)) ** GOTO lbl26
                jsonrpcRequest = (McpSchema.JSONRPCRequest)message;
                if (!"logging/setLevel".equals(jsonrpcRequest.method())) break block12;
                McpHttpTransport.logger.info("Handling logging/setLevel request directly");
                response = new McpSchema.JSONRPCResponse("2.0", jsonrpcRequest.id(), new HashMap<K, V>(), null);
                return this.createHttpResponse(200, this.mapper.writeValueAsString((Object)response));
                {
                    catch (Exception e) {
                        return this.createErrorResponse(500, "Unexpected error handling message: " + e.getMessage(), e);
                    }
                }
            }
            try {
                jsonrpcResponse = (McpSchema.JSONRPCResponse)this.mcpHandler.handleRequest(context, jsonrpcRequest).contextWrite((Function<Context, Context>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handlePost$2(io.modelcontextprotocol.server.McpTransportContext reactor.util.context.Context ), (Lreactor/util/context/Context;)Lreactor/util/context/Context;)((McpTransportContext)context)).block();
                return this.createHttpResponse(200, this.mapper.writeValueAsString((Object)jsonrpcResponse));
            }
            catch (Exception e) {
                return this.createErrorResponse(500, "Failed to handle request: " + e.getMessage(), e);
lbl26:
                // 1 sources

                if (!(message instanceof McpSchema.JSONRPCNotification)) {
                    McpHttpTransport.logger.log(Level.SEVERE, "Message type must be either JSONRPCRequest or JSONRPCNotification, but was: " + message.getClass().getName());
                    return this.createErrorResponse(400, "The server only accepts jsonrpc requests and notifications", null);
                }
                jsonrpcNotification = (McpSchema.JSONRPCNotification)message;
                try {
                    this.mcpHandler.handleNotification(context, jsonrpcNotification).contextWrite((Function<Context, Context>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handlePost$3(io.modelcontextprotocol.server.McpTransportContext reactor.util.context.Context ), (Lreactor/util/context/Context;)Lreactor/util/context/Context;)((McpTransportContext)context)).block();
                    return this.createHttpResponse(202, null);
                }
                catch (Exception e) {
                    return this.createErrorResponse(500, "Failed to handle notification: " + e.getMessage(), e);
                }
            }
        }
        catch (IOException | IllegalArgumentException e) {
            return this.createErrorResponse(400, "Failed to deserialize message: " + e.getMessage(), e);
        }
    }

    public HttpResponse handleDelete(HttpRequest request) {
        return this.createHttpResponse(405, null);
    }

    private static /* synthetic */ Context lambda$handlePost$3(McpTransportContext context, Context ctx) {
        return ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)context);
    }

    private static /* synthetic */ Context lambda$handlePost$2(McpTransportContext context, Context ctx) {
        return ctx.put((Object)"MCP_TRANSPORT_CONTEXT", (Object)context);
    }
}

