/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers;

import com.yahoo.io.FatalErrorHandler;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.LogHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HandlerThread
extends Thread
implements LogHandler {
    private static final Logger log = Logger.getLogger(HandlerThread.class.getName());
    public static final int DEFAULT_QUEUESIZE = 200;
    private static int queueSize = 200;
    private FatalErrorHandler fatalErrorHandler;
    private final BlockingQueue<ItemOrList> queue;
    private final List<LogHandler> handlers = new ArrayList<LogHandler>();

    public HandlerThread(String name) {
        super(name);
        this.queue = new LinkedBlockingQueue<ItemOrList>(queueSize);
        log.log(Level.CONFIG, "logserver.queue.size=" + queueSize);
    }

    public synchronized void setFatalErrorHandler(FatalErrorHandler f) {
        this.fatalErrorHandler = f;
    }

    @Override
    public void handle(LogMessage message) {
        this.handleInternal(new ItemOrList(message));
    }

    @Override
    public void handle(List<LogMessage> messages) {
        this.handleInternal(new ItemOrList(messages));
    }

    private void handleInternal(ItemOrList o) {
        boolean done = false;
        while (!done) {
            try {
                this.queue.put(o);
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void flush() {
        for (LogHandler handler : this.handlers) {
            handler.flush();
        }
    }

    @Override
    public void close() {
        for (LogHandler handler : this.handlers) {
            handler.close();
        }
    }

    public synchronized void registerHandler(LogHandler handler) {
        log.fine("Registering handler " + handler);
        this.handlers.add(handler);
    }

    public synchronized void unregisterHandler(LogHandler handler) {
        int idx;
        while ((idx = this.handlers.indexOf(handler)) != -1) {
            try {
                this.handlers.remove(idx);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public LogHandler[] getHandlers() {
        LogHandler[] h = new LogHandler[this.handlers.size()];
        return this.handlers.toArray(h);
    }

    public BlockingQueue<ItemOrList> getQueue() {
        return this.queue;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        String queueSizeStr = System.getProperty("logserver.queue.size");
        if (queueSizeStr != null) {
            queueSize = Integer.parseInt(queueSizeStr);
            if (queueSize < 50) {
                queueSize = 50;
            }
            log.info("set queue size to " + queueSize);
        }
    }

    private static class ItemOrList {
        final LogMessage item;
        final List<LogMessage> list;

        ItemOrList(LogMessage i) {
            this.item = i;
            this.list = null;
        }

        ItemOrList(List<LogMessage> l) {
            this.item = null;
            this.list = l;
        }

        public String toString() {
            return "item=" + this.item + ", list=" + this.list;
        }
    }
}

