/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import com.yahoo.logserver.PluginLoader;
import com.yahoo.plugin.Plugin;
import com.yahoo.plugin.SystemPropertyConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPluginLoader
implements PluginLoader {
    private static final Logger log = Logger.getLogger(AbstractPluginLoader.class.getName());

    @Override
    public abstract void loadPlugins();

    protected void loadFromClass(Class<? extends Plugin> pluginClass) {
        Plugin plugin;
        try {
            plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.log(Level.SEVERE, pluginClass.getName() + ": load failed: " + e);
            throw new RuntimeException(e);
        }
        String pname = plugin.getPluginName();
        String prefix = "logserver." + pname + ".";
        SystemPropertyConfig config = new SystemPropertyConfig(prefix);
        String enable = config.get("enable", "true");
        if (!enable.equals("true")) {
            log.log(Level.INFO, pname + ": plugin disabled by config");
            return;
        }
        try {
            plugin.initPlugin(config);
            log.log(Level.FINE, pname + ": plugin loaded");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, pname + ": init failed", e);
        }
    }
}

