/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public class FilesArchived {
    private static final Logger log = Logger.getLogger(FilesArchived.class.getName());
    private final File root;
    private final Object mutex = new Object();
    private List<LogFile> knownFiles;
    public static final long compressAfterMillis = 0x6DDD00L;
    private static final long maxAgeDays = 30L;
    private static final long sizeLimit = 0x780000000L;
    private static final Pattern dateFormatRegexp = Pattern.compile(".*/[0-9][0-9][0-9][0-9]/[0-9][0-9]/[0-9][0-9]/[0-9][0-9]-[0-9].*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTrigger(long milliS) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.wait(milliS);
        }
    }

    private void run() {
        try {
            Thread.sleep(1000L);
            while (true) {
                this.maintenance();
                this.waitForTrigger(2000L);
            }
        }
        catch (Exception e) {
            System.err.println("Fatal exception in FilesArchived-maintainer thread: " + e);
            return;
        }
    }

    public FilesArchived(File rootDir) {
        this.root = rootDir;
        this.rescan();
        Thread thread = new Thread(this::run);
        thread.setDaemon(true);
        thread.setName("FilesArchived-maintainer");
        thread.start();
    }

    public String toString() {
        return FilesArchived.class.getName() + ": root=" + this.root;
    }

    public synchronized int highestGen(String prefix) {
        int gen = 0;
        for (LogFile lf : this.knownFiles) {
            if (!prefix.equals(lf.prefix)) continue;
            gen = Math.max(gen, lf.generation);
        }
        return gen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMaintenance() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    synchronized boolean maintenance() {
        boolean action = false;
        this.rescan();
        if (this.removeOlderThan(30L)) {
            action = true;
            this.rescan();
        }
        if (this.compressOldFiles()) {
            action = true;
            this.rescan();
        }
        long days = 30L;
        while (this.tooMuchDiskUsage() && --days > 1L) {
            if (!this.removeOlderThan(days)) continue;
            action = true;
            this.rescan();
        }
        return action;
    }

    private void rescan() {
        this.knownFiles = FilesArchived.scanDir(this.root);
    }

    boolean tooMuchDiskUsage() {
        long sz = this.sumFileSizes();
        return sz > 0x780000000L;
    }

    private boolean olderThan(LogFile lf, long days, long now) {
        long mtime = lf.path.lastModified();
        long diff = now - mtime;
        return diff > days * 86400L * 1000L;
    }

    private boolean removeOlderThan(long days) {
        boolean action = false;
        long now = System.currentTimeMillis();
        for (LogFile lf : this.knownFiles) {
            if (!this.olderThan(lf, days, now)) continue;
            lf.path.delete();
            log.info("Deleted: " + lf.path);
            action = true;
        }
        return action;
    }

    private boolean compressOldFiles() {
        long now = System.currentTimeMillis();
        int count = 0;
        for (LogFile lf : this.knownFiles) {
            if (!lf.canCompress(now) || count++ >= 5) continue;
            this.compress(lf.path);
        }
        return count > 0;
    }

    private void compress(File oldFile) {
        File gzippedFile = new File(oldFile.getPath() + ".gz");
        try (GZIPOutputStream compressor = new GZIPOutputStream((OutputStream)new FileOutputStream(gzippedFile), 0x100000);
             FileInputStream inputStream = new FileInputStream(oldFile);){
            long mtime = oldFile.lastModified();
            byte[] buffer = new byte[0x100000];
            int read = inputStream.read(buffer);
            while (read > 0) {
                compressor.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            compressor.finish();
            compressor.flush();
            oldFile.delete();
            gzippedFile.setLastModified(mtime);
            log.info("Compressed: " + gzippedFile);
        }
        catch (IOException e) {
            log.warning("Got '" + e + "' while compressing '" + oldFile.getPath() + "'.");
        }
    }

    long sumFileSizes() {
        long sum = 0L;
        for (LogFile lf : this.knownFiles) {
            sum += lf.path.length();
        }
        return sum;
    }

    private static List<LogFile> scanDir(File top) {
        ArrayList<LogFile> retval = new ArrayList<LogFile>();
        String[] names = top.list();
        if (names != null) {
            for (String name : names) {
                File sub = new File(top, name);
                if (sub.isFile()) {
                    String pathName = sub.toString();
                    if (dateFormatRegexp.matcher(pathName).matches()) {
                        retval.add(new LogFile(sub));
                        continue;
                    }
                    log.warning("skipping file not matching log archive pattern: " + pathName);
                    continue;
                }
                if (!sub.isDirectory()) continue;
                retval.addAll(FilesArchived.scanDir(sub));
            }
        }
        return retval;
    }

    static class LogFile {
        public final File path;
        public final String prefix;
        public final int generation;
        public final boolean zsuff;

        public boolean canCompress(long now) {
            if (this.zsuff) {
                return false;
            }
            if (!this.path.isFile()) {
                return false;
            }
            long diff = now - this.path.lastModified();
            return diff >= 0x6DDD00L;
        }

        private static int generationOf(String name) {
            int dash = name.lastIndexOf(45);
            if (dash < 0) {
                return 0;
            }
            String suff = name.substring(dash + 1);
            int r = 0;
            for (char ch : suff.toCharArray()) {
                if (ch < '0' || ch > '9') break;
                r *= 10;
                r += ch - 48;
            }
            return r;
        }

        private static String prefixOf(String name) {
            int dash = name.lastIndexOf(45);
            if (dash < 0) {
                return name;
            }
            return name.substring(0, dash);
        }

        private static boolean zSuffix(String name) {
            return name.endsWith(".gz");
        }

        public LogFile(File path) {
            String name = path.toString();
            this.path = path;
            this.prefix = LogFile.prefixOf(name);
            this.generation = LogFile.generationOf(name);
            this.zsuff = LogFile.zSuffix(name);
        }

        public String toString() {
            return "FilesArchived.LogFile{name=" + this.path + " prefix=" + this.prefix + " gen=" + this.generation + " z=" + this.zsuff + "}";
        }
    }
}

