/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.replicator;

import com.yahoo.io.Connection;
import com.yahoo.io.IOUtils;
import com.yahoo.io.Listener;
import com.yahoo.io.ReadLine;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.filter.LogFilter;
import com.yahoo.logserver.filter.LogFilterManager;
import com.yahoo.logserver.formatter.LogFormatter;
import com.yahoo.logserver.formatter.LogFormatterManager;
import com.yahoo.logserver.handlers.replicator.Replicator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicatorConnection
implements Connection,
LogFilter {
    private static final Logger log = Logger.getLogger(ReplicatorConnection.class.getName());
    private static final int maxQueueLength;
    private static final int maxRetriesBeforeWarning = 10;
    private static int queueFullCount;
    private final SocketChannel socket;
    private final String remoteHost;
    private final Listener listener;
    private final Replicator replicator;
    private final LinkedList<ByteBuffer> writeBufferList = new LinkedList();
    private ByteBuffer writeBuffer;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(4096);
    private LogFilter filter = null;
    protected LogFormatter formatter = null;
    private String filterName = "system.mute";
    private String formatterName = "system.nullformatter";
    private boolean droppingMode = false;
    private int numHandled = 0;
    private int numQueued = 0;
    private int numDropped = 0;
    private long totalBytesWritten = 0L;

    public ReplicatorConnection(SocketChannel socket, Listener listener, Replicator replicator) {
        this.socket = socket;
        this.listener = listener;
        this.replicator = replicator;
        this.filter = LogFilterManager.getLogFilter(this.filterName);
        this.formatter = LogFormatterManager.getLogFormatter(this.formatterName);
        this.remoteHost = socket.socket().getInetAddress().getHostName();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public boolean isLoggable(LogMessage msg) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.isLoggable(msg);
    }

    @Override
    public String description() {
        if (this.filter == null) {
            return "No filter defined";
        }
        return this.filter.description();
    }

    public synchronized void enqueue(ByteBuffer buffer) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = buffer;
        } else {
            if (this.writeBufferList.size() > maxQueueLength) {
                ++queueFullCount;
                if (!this.droppingMode) {
                    this.droppingMode = true;
                    String message = "client at " + this.remoteHost + " can't keep up, dropping messages";
                    if (queueFullCount > 10) {
                        log.log(LogLevel.WARNING, message);
                        queueFullCount = 0;
                    } else {
                        log.log((Level)LogLevel.DEBUG, message);
                    }
                }
                ++this.numDropped;
                return;
            }
            this.writeBufferList.addLast(buffer);
            this.listener.modifyInterestOps((Connection)this, 4, true);
            this.droppingMode = false;
            ++this.numQueued;
        }
        ++this.numHandled;
        this.write();
    }

    public void read() throws IOException {
        String s;
        if (!this.readBuffer.hasRemaining()) {
            log.warning("Log message too long. Message exceeds " + this.readBuffer.capacity() + " bytes.  Connection dropped.");
            this.close();
            return;
        }
        int ret = this.socket.read(this.readBuffer);
        if (ret == -1) {
            this.close();
            return;
        }
        if (ret == 0 && log.isLoggable((Level)LogLevel.DEBUG)) {
            log.fine("zero byte read occurred");
        }
        this.readBuffer.flip();
        while ((s = ReadLine.readLine((ByteBuffer)this.readBuffer)) != null) {
            this.onCommand(s);
        }
    }

    public synchronized void write() throws IOException {
        int bytesWritten;
        if (!this.socket.isOpen()) {
            this.close();
        }
        do {
            if (this.writeBuffer == null) {
                if (this.writeBufferList.isEmpty()) {
                    this.listener.modifyInterestOpsBatch((Connection)this, 4, false);
                    return;
                }
                this.writeBuffer = this.writeBufferList.removeFirst();
            }
            try {
                bytesWritten = this.socket.write(this.writeBuffer);
            }
            catch (IOException e) {
                this.close();
                return;
            }
            this.totalBytesWritten += (long)bytesWritten;
            if (this.writeBuffer == null || this.writeBuffer.hasRemaining()) continue;
            this.writeBuffer = null;
        } while (bytesWritten > 0);
    }

    public synchronized void close() throws IOException {
        this.replicator.deRegisterConnection(this);
        this.socket.close();
        this.writeBuffer = null;
        this.writeBufferList.clear();
        log.log((Level)LogLevel.DEBUG, "closing connection to " + this.remoteHost);
    }

    public int selectOps() {
        return 1;
    }

    public SocketChannel socketChannel() {
        return this.socket;
    }

    public void connect() {
    }

    void onCommand(String s) {
        log.log((Level)LogLevel.DEBUG, "COMMAND: '" + s + "' from " + this.remoteHost);
        StringTokenizer st = new StringTokenizer(s.toLowerCase());
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if ("ping".equals(tok)) {
                if (st.hasMoreTokens()) {
                    this.print("# 202 pong " + st.nextToken() + "\n");
                } else {
                    this.print("# 202 pong\n");
                }
                return;
            }
            if ("use".equals(tok)) {
                if (st.hasMoreTokens()) {
                    this.onUse(st.nextToken());
                }
                return;
            }
            if ("formatter".equals(tok)) {
                if (st.hasMoreTokens()) {
                    this.onFormatter(st.nextToken());
                }
                return;
            }
            if ("quit".equals(tok)) {
                this.print("# 201 bye\n");
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if ("list".equals(tok)) {
                this.onList();
                return;
            }
            if ("listformatters".equals(tok)) {
                this.onListFormatters();
                return;
            }
            if (!"stats".equals(tok)) continue;
            this.onStats();
            return;
        }
    }

    void onFormatter(String formatterName) {
        LogFormatter newFormatter = LogFormatterManager.getLogFormatter(formatterName);
        if (newFormatter == null) {
            this.print("# 405 formatter not found '" + formatterName + "'\n");
            return;
        }
        this.formatter = newFormatter;
        this.formatterName = formatterName;
        this.print("# 202 using '" + this.formatter + "'\n");
    }

    void onUse(String filterName) {
        LogFilter newFilter = LogFilterManager.getLogFilter(filterName);
        if (newFilter == null) {
            this.print("# 404 filter not found '" + filterName + "'\n");
            return;
        }
        this.filter = newFilter;
        this.filterName = filterName;
        this.print("# 200 using '" + this.filter + "'\n");
    }

    void onList() {
        this.print("# 203 filter list\n");
        String[] filterNames = LogFilterManager.getFilterNames();
        for (int i = 0; i < filterNames.length; ++i) {
            LogFilter f = LogFilterManager.getLogFilter(filterNames[i]);
            this.print("# 204 " + filterNames[i] + " - " + f.description() + "\n");
        }
        this.print("# 205 end filter list\n");
    }

    void onListFormatters() {
        this.print("# 206 formatter list\n");
        String[] formatterNames = LogFormatterManager.getFormatterNames();
        for (int i = 0; i < formatterNames.length; ++i) {
            LogFormatter fmt = LogFormatterManager.getLogFormatter(formatterNames[i]);
            this.print("# 207 " + formatterNames[i] + " - " + fmt.description() + "\n");
        }
        this.print("# 208 end formatter list\n");
    }

    private void print(String s) {
        try {
            this.enqueue(IOUtils.utf8ByteBuffer((String)s));
        }
        catch (IOException e) {
            log.log(LogLevel.WARNING, "error printing", e);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void onStats() {
        this.print(new StringBuilder(80).append("# 206 stats start (this connection)\n").append("# 207 ").append(this.numHandled).append(" handled\n").append("# 208 ").append(this.numDropped).append(" dropped\n").append("# 209 ").append(this.numQueued).append(" handled and queued\n").append("# 210 ").append(this.totalBytesWritten).append(" total bytes written\n").append("# 211 stats end\n").toString());
    }

    public int getNumHandled() {
        return this.numHandled;
    }

    public int getNumQueued() {
        return this.numQueued;
    }

    public int getNumDropped() {
        return this.numDropped;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public String getLogFilterName() {
        return this.filterName;
    }

    void setFilter(LogFilter filter) {
        this.filter = filter;
    }

    static {
        queueFullCount = 0;
        String maxQueue = System.getProperty("logserver.replicator.maxqueuelength", "5000");
        maxQueueLength = Integer.parseInt(maxQueue);
    }
}

