/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.formatter;

import com.yahoo.log.LogMessage;
import com.yahoo.logserver.formatter.LogFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TextFormatter
implements LogFormatter {
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String format(LogMessage msg) {
        StringBuffer sbuf = new StringBuffer(150);
        sbuf.append(dateFormat.format(new Date(msg.getTime()))).append(" ").append(msg.getHost()).append(" ").append(msg.getThreadProcess()).append(" ").append(msg.getService()).append(" ").append(msg.getComponent()).append(" ").append(msg.getLevel().toString()).append(" ").append(msg.getPayload()).append("\n");
        return sbuf.toString();
    }

    @Override
    public String description() {
        return "Format log-message as human readable text";
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

