/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.logserver.protocol;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;

public class RpcServer
implements AutoCloseable {
    private final Supervisor supervisor = new Supervisor(new Transport());
    private final int listenPort;
    private Acceptor acceptor;

    public RpcServer(int listenPort) {
        this.listenPort = listenPort;
    }

    public void addMethod(Method method) {
        this.supervisor.addMethod(method);
    }

    public void start() {
        try {
            this.acceptor = this.supervisor.listen(new Spec(this.listenPort));
        }
        catch (ListenFailedException e) {
            throw new RuntimeException(e);
        }
    }

    int listenPort() {
        return this.acceptor.port();
    }

    @Override
    public void close() {
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
        }
        this.supervisor.transport().shutdown().join();
    }
}

