/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.lasterrorsholder;

import com.yahoo.io.Connection;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.filter.LogFilter;
import com.yahoo.logserver.filter.LogFilterManager;
import com.yahoo.logserver.formatter.LogFormatter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

public class LastErrorsHolderConnection
implements Connection,
LogFilter {
    private static final Logger log = Logger.getLogger(LastErrorsHolderConnection.class.getName());
    private final SocketChannel socket;
    private ByteBuffer writeBuffer;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(4096);
    private LogFilter filter = null;
    protected LogFormatter formatter = null;
    private static final String filterName = "system.mute";

    public LastErrorsHolderConnection(SocketChannel socket) {
        this.socket = socket;
        this.filter = LogFilterManager.getLogFilter(filterName);
    }

    @Override
    public boolean isLoggable(LogMessage msg) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.isLoggable(msg);
    }

    @Override
    public String description() {
        if (this.filter == null) {
            return "No filter defined";
        }
        return this.filter.description();
    }

    public synchronized void enqueue(ByteBuffer buffer) throws IOException {
        this.writeBuffer = buffer;
        this.write();
    }

    public void read() throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            log.warning("Log message too long. Message exceeds " + this.readBuffer.capacity() + " bytes.  Connection dropped.");
            this.close();
            return;
        }
        int ret = this.socket.read(this.readBuffer);
        if (ret == -1) {
            this.close();
            return;
        }
        if (ret == 0 && log.isLoggable(LogLevel.INFO)) {
            log.log(LogLevel.INFO, "zero byte read occurred");
        }
        this.readBuffer.flip();
    }

    public synchronized void write() throws IOException {
        if (!this.socket.isOpen()) {
            this.close();
        }
        do {
            try {
                this.socket.write(this.writeBuffer);
            }
            catch (IOException e) {
                log.log(LogLevel.WARNING, "Error writing", e);
                this.close();
                return;
            }
        } while (this.writeBuffer.hasRemaining());
    }

    public synchronized void close() throws IOException {
        this.socket.close();
        this.writeBuffer = null;
    }

    public int selectOps() {
        return 1;
    }

    public SocketChannel socketChannel() {
        return this.socket;
    }

    public void connect() {
    }

    void setFilter(LogFilter filter) {
        this.filter = filter;
    }
}

