/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver;

import com.yahoo.io.SelectLoopHook;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.handlers.LogHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogDispatcher
implements LogHandler,
SelectLoopHook {
    private static final Logger log = Logger.getLogger(LogDispatcher.class.getName());
    private final List<LogHandler> handlers = new ArrayList<LogHandler>();
    private int messageCount = 0;
    private boolean hasBeenShutDown = false;
    private boolean batchedMode = false;
    private final int batchSize = 5000;
    private List<LogMessage> currentBatchList;
    private int roundCount = 0;
    private int lastRoundCount = 0;

    @Override
    public synchronized void handle(LogMessage msg) {
        if (msg == null) {
            throw new NullPointerException("LogMessage was null");
        }
        if (this.batchedMode) {
            this.addToBatch(msg);
        } else {
            for (LogHandler h : this.handlers) {
                h.handle(msg);
            }
        }
        ++this.messageCount;
    }

    private void addToBatch(LogMessage msg) {
        if (this.currentBatchList == null) {
            this.currentBatchList = new ArrayList<LogMessage>(5000);
            this.currentBatchList.add(msg);
            return;
        }
        this.currentBatchList.add(msg);
        if (this.currentBatchList.size() == 5000) {
            this.flushBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBatch() {
        List<LogMessage> todo;
        LogDispatcher logDispatcher = this;
        synchronized (logDispatcher) {
            todo = this.currentBatchList;
            this.currentBatchList = null;
        }
        if (todo == null) {
            return;
        }
        for (LogHandler ht : this.handlers) {
            ht.handle(todo);
        }
    }

    @Override
    public void handle(List<LogMessage> messages) {
        throw new IllegalStateException("method not supported");
    }

    public void setBatchedMode(boolean batchedMode) {
        this.batchedMode = batchedMode;
    }

    @Override
    public synchronized void flush() {
        if (this.batchedMode) {
            this.flushBatch();
        }
        for (LogHandler h : this.handlers) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Flushing " + h.toString());
            }
            h.flush();
        }
    }

    @Override
    public synchronized void close() {
        if (this.hasBeenShutDown) {
            throw new IllegalStateException("Shutdown already in progress");
        }
        this.hasBeenShutDown = true;
        for (LogHandler ht : this.handlers) {
            if (!(ht instanceof Thread)) continue;
            log.fine("Stopping " + ht);
            ((Thread)((Object)ht)).interrupt();
        }
        this.handlers.clear();
        log.log((Level)LogLevel.DEBUG, "Logdispatcher shut down.  Handled " + this.messageCount + " messages");
    }

    public synchronized void registerLogHandler(LogHandler ht) {
        if (this.hasBeenShutDown) {
            throw new IllegalStateException("Tried to register LogHandler on LogDispatcher which was shut down");
        }
        if (this.handlers.contains(ht)) {
            log.warning("LogHandler was already registered: " + ht);
            return;
        }
        this.handlers.add(ht);
        if (ht instanceof Thread && !((Thread)((Object)ht)).isAlive()) {
            ((Thread)((Object)ht)).start();
        }
        log.fine("Added (and possibly started) LogHandler " + ht);
    }

    public LogHandler[] getLogHandlers() {
        LogHandler[] h = new LogHandler[this.handlers.size()];
        return this.handlers.toArray(h);
    }

    public synchronized int getMessageCount() {
        return this.messageCount;
    }

    public void selectLoopHook(boolean before) {
        if (this.batchedMode) {
            this.flushBatch();
        }
        this.lastRoundCount = this.messageCount - this.roundCount;
        this.roundCount = this.messageCount;
    }
}

