/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.net;

import com.yahoo.io.Connection;
import com.yahoo.io.Listener;
import com.yahoo.io.ReadLine;
import com.yahoo.log.InvalidLogFormatException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.logserver.LogDispatcher;
import com.yahoo.logserver.net.control.Levels;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConnection
implements Connection {
    private static final Logger log = Logger.getLogger(LogConnection.class.getName());
    public static final int READBUFFER_SIZE = 32768;
    private static final Charset charset = Charset.forName("utf-8");
    private static final Set<LogConnection> activeConnections = new HashSet<LogConnection>();
    private final SocketChannel socket;
    private final Listener listener;
    private final LogDispatcher dispatcher;
    private final ByteBuffer readBuffer = ByteBuffer.allocateDirect(32768);
    private final LinkedList<ByteBuffer> writeBufferList = new LinkedList();
    private ByteBuffer writeBuffer;
    private long totalBytesRead = 0L;
    private long totalBytesWritten = 0L;
    final Levels defaultLevels;

    public LogConnection(SocketChannel socket, Listener listener, LogDispatcher dispatcher, Levels defaultLevels) {
        this.socket = socket;
        this.listener = listener;
        this.dispatcher = dispatcher;
        this.defaultLevels = defaultLevels;
        LogConnection.addToActiveSet(this);
        this.sendDefaultState();
    }

    public void sendDefaultState() {
        if (this.defaultLevels == null) {
            return;
        }
        try {
            this.enqueue(charset.encode("setdefaultstate " + this.defaultLevels.toString() + "\n"));
            this.enqueue(charset.encode("setallstates " + this.defaultLevels.toString() + "\n"));
        }
        catch (IOException e) {
            log.log(LogLevel.WARNING, "Unable to send default state", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<LogConnection> getActiveConnections() {
        Set<LogConnection> set = activeConnections;
        synchronized (set) {
            return new HashSet<LogConnection>(activeConnections);
        }
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToActiveSet(LogConnection connection) {
        Set<LogConnection> set = activeConnections;
        synchronized (set) {
            activeConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromActiveSet(LogConnection connection) {
        Set<LogConnection> set = activeConnections;
        synchronized (set) {
            activeConnections.remove(connection);
        }
    }

    public synchronized void enqueue(ByteBuffer buffer) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = buffer;
        } else {
            this.writeBufferList.addLast(buffer);
            this.listener.modifyInterestOps((Connection)this, 4, true);
        }
        this.write();
    }

    public void connect() throws IOException {
        throw new RuntimeException("connect() is not supposed to be called");
    }

    public synchronized void write() throws IOException {
        int bytesWritten;
        do {
            if (this.writeBuffer == null) {
                if (this.writeBufferList.isEmpty()) {
                    this.listener.modifyInterestOpsBatch((Connection)this, 4, false);
                    return;
                }
                this.writeBuffer = this.writeBufferList.removeFirst();
            }
            bytesWritten = this.socket.write(this.writeBuffer);
            this.totalBytesWritten += (long)bytesWritten;
            if (this.writeBuffer == null || this.writeBuffer.hasRemaining()) continue;
            this.writeBuffer = null;
        } while (bytesWritten > 0);
    }

    public void read() throws IOException {
        String s;
        if (!this.readBuffer.hasRemaining()) {
            try {
                this.readBuffer.putChar(this.readBuffer.capacity() - 2, '\n');
                this.readBuffer.flip();
                String s2 = ReadLine.readLine((ByteBuffer)this.readBuffer);
                if (s2 == null) {
                    return;
                }
                log.log((Level)LogLevel.DEBUG, "Log message too long. Message from " + this.socket.socket().getInetAddress() + " exceeds " + this.readBuffer.capacity() + ". The message was: " + s2);
                LogMessage msg = LogMessage.parseNativeFormat((String)s2);
                this.dispatcher.handle(msg);
            }
            catch (InvalidLogFormatException e) {
                log.log((Level)LogLevel.DEBUG, "Invalid log message", e);
            }
            finally {
                this.readBuffer.clear();
            }
            return;
        }
        int ret = this.socket.read(this.readBuffer);
        if (ret == -1) {
            this.close();
            return;
        }
        if (ret == 0 && log.isLoggable(Level.FINE)) {
            log.log((Level)LogLevel.DEBUG, "zero byte read occurred");
        }
        this.totalBytesRead += (long)ret;
        this.readBuffer.flip();
        while ((s = ReadLine.readLine((ByteBuffer)this.readBuffer)) != null) {
            try {
                LogMessage msg = LogMessage.parseNativeFormat((String)s);
                this.dispatcher.handle(msg);
            }
            catch (InvalidLogFormatException e) {
                log.log((Level)LogLevel.DEBUG, "Invalid log message", e);
            }
        }
    }

    public void close() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(LogLevel.INFO, this + ": closing");
        }
        this.socket.close();
        LogConnection.removeFromActiveSet(this);
    }

    public int selectOps() {
        return 1;
    }

    public SocketChannel socketChannel() {
        return this.socket;
    }
}

