/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.handlers.lasterrorsholder;

import com.yahoo.log.LogLevel;
import com.yahoo.logserver.Server;
import com.yahoo.logserver.handlers.lasterrorsholder.LastErrorsHolder;
import com.yahoo.plugin.Config;
import com.yahoo.plugin.Plugin;
import java.io.IOException;
import java.util.logging.Logger;

public class LastErrorsHolderPlugin
implements Plugin {
    private static final String DEFAULT_PORT = "19082";
    private static final Logger log = Logger.getLogger(LastErrorsHolderPlugin.class.getName());
    private LastErrorsHolder lastErrorsHolder;
    private final Server server = Server.getInstance();

    @Override
    public String getPluginName() {
        return "last-errors-holder";
    }

    @Override
    public void initPlugin(Config config) {
        if (this.lastErrorsHolder != null) {
            throw new IllegalStateException("plugin already initialized: " + this.getPluginName());
        }
        int listenPort = config.getInt("port", DEFAULT_PORT);
        String threadName = config.get("thread", this.getPluginName());
        try {
            this.lastErrorsHolder = new LastErrorsHolder(listenPort);
        }
        catch (IOException e) {
            log.log(LogLevel.WARNING, "init failed: " + e);
            return;
        }
        this.server.registerLogHandler(this.lastErrorsHolder, threadName);
    }

    @Override
    public void shutdownPlugin() {
        if (this.lastErrorsHolder == null) {
            throw new IllegalStateException("plugin not initialized: " + this.getPluginName());
        }
        this.server.unregisterLogHandler(this.lastErrorsHolder);
        this.lastErrorsHolder = null;
    }
}

