/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.huggingface;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class HuggingFaceTokenizerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8823d722ab307c56bd6744c5c4dcf6f2";
    public static final String CONFIG_DEF_NAME = "hugging-face-tokenizer";
    public static final String CONFIG_DEF_NAMESPACE = "language.huggingface";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=language.huggingface", "model[].language string", "model[].path model", "addSpecialTokens bool default=true"};
    private final InnerNodeVector<Model> model;
    private final BooleanNode addSpecialTokens;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HuggingFaceTokenizerConfig(Builder builder) {
        this(builder, true);
    }

    private HuggingFaceTokenizerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for hugging-face-tokenizer must be initialized: " + builder.__uninitialized);
        }
        this.model = Model.createVector(builder.model);
        this.addSpecialTokens = builder.addSpecialTokens == null ? new BooleanNode(true) : new BooleanNode(builder.addSpecialTokens.booleanValue());
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    public boolean addSpecialTokens() {
        return this.addSpecialTokens.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HuggingFaceTokenizerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private Boolean addSpecialTokens = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HuggingFaceTokenizerConfig config) {
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
            this.addSpecialTokens(config.addSpecialTokens());
        }

        private Builder override(Builder __superior) {
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            if (__superior.addSpecialTokens != null) {
                this.addSpecialTokens(__superior.addSpecialTokens);
            }
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(Consumer<Model.Builder> __func) {
            Model.Builder __inner = new Model.Builder();
            __func.accept(__inner);
            this.model.add(__inner);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public Builder addSpecialTokens(boolean __value) {
            this.addSpecialTokens = __value;
            return this;
        }

        private Builder addSpecialTokens(String __value) {
            return this.addSpecialTokens(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HuggingFaceTokenizerConfig build() {
            return new HuggingFaceTokenizerConfig(this);
        }
    }

    public static final class Model
    extends InnerNode {
        private final StringNode language;
        private final ModelNode path;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for hugging-face-tokenizer.model[] must be initialized: " + builder.__uninitialized);
            }
            this.language = builder.language == null ? new StringNode() : new StringNode(builder.language);
            this.path = builder.path == null ? new ModelNode() : new ModelNode(builder.path);
        }

        public String language() {
            return this.language.value();
        }

        public Path path() {
            return (Path)this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("language", "path"));
            private String language = null;
            private ModelReference path = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.language(config.language());
                this.path(config.path.getModelReference());
            }

            private Builder override(Builder __superior) {
                if (__superior.language != null) {
                    this.language(__superior.language);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder language(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.language = __value;
                this.__uninitialized.remove("language");
                return this;
            }

            public Builder path(ModelReference __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

