/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.sentencepiece;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.PathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SentencePieceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "53e079539fe07490484363d3a48a84b1";
    public static final String CONFIG_DEF_NAME = "sentence-piece";
    public static final String CONFIG_DEF_NAMESPACE = "language.sentencepiece";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=language.sentencepiece", "collapseUnknowns bool default=true", "scoring enum { highestScore, fewestSegments } default=fewestSegments", "model[].language string", "model[].path path"};
    private final BooleanNode collapseUnknowns;
    private final Scoring scoring;
    private final InnerNodeVector<Model> model;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public SentencePieceConfig(Builder builder) {
        this(builder, true);
    }

    private SentencePieceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for sentence-piece must be initialized: " + builder.__uninitialized);
        }
        this.collapseUnknowns = builder.collapseUnknowns == null ? new BooleanNode(true) : new BooleanNode(builder.collapseUnknowns.booleanValue());
        this.scoring = builder.scoring == null ? new Scoring(Scoring.fewestSegments) : new Scoring(builder.scoring);
        this.model = Model.createVector(builder.model);
    }

    public boolean collapseUnknowns() {
        return this.collapseUnknowns.value();
    }

    public Scoring.Enum scoring() {
        return (Scoring.Enum)((Object)this.scoring.value());
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SentencePieceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Model
    extends InnerNode {
        private final StringNode language;
        private final PathNode path;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for sentence-piece.model[] must be initialized: " + builder.__uninitialized);
            }
            this.language = builder.language == null ? new StringNode() : new StringNode(builder.language);
            this.path = builder.path == null ? new PathNode() : new PathNode(builder.path);
        }

        public String language() {
            return this.language.value();
        }

        public Path path() {
            return this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("language", "path"));
            private String language = null;
            private FileReference path = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.language(config.language());
                this.path(config.path.getFileReference());
            }

            private Builder override(Builder __superior) {
                if (__superior.language != null) {
                    this.language(__superior.language);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder language(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.language = __value;
                this.__uninitialized.remove("language");
                return this;
            }

            public Builder path(FileReference __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static final class Scoring
    extends EnumNode<Enum> {
        public static final Enum highestScore = Enum.highestScore;
        public static final Enum fewestSegments = Enum.fewestSegments;

        public Scoring() {
            this.value = null;
        }

        public Scoring(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            highestScore,
            fewestSegments;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean collapseUnknowns = null;
        private Scoring.Enum scoring = null;
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SentencePieceConfig config) {
            this.collapseUnknowns(config.collapseUnknowns());
            this.scoring(config.scoring());
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.collapseUnknowns != null) {
                this.collapseUnknowns(__superior.collapseUnknowns);
            }
            if (__superior.scoring != null) {
                this.scoring(__superior.scoring);
            }
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            return this;
        }

        public Builder collapseUnknowns(boolean __value) {
            this.collapseUnknowns = __value;
            return this;
        }

        private Builder collapseUnknowns(String __value) {
            return this.collapseUnknowns(Boolean.valueOf(__value));
        }

        public Builder scoring(Scoring.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.scoring = __value;
            return this;
        }

        private Builder scoring(String __value) {
            return this.scoring(Scoring.Enum.valueOf(__value));
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SentencePieceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SentencePieceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SentencePieceConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SentencePieceConfig build() {
            return new SentencePieceConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

