/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.sentencepiece;

import com.yahoo.language.sentencepiece.SentencePieceAlgorithm;
import com.yahoo.language.sentencepiece.TokenType;

abstract class ResultBuilder<RESULTTYPE> {
    private final RESULTTYPE result;

    ResultBuilder(RESULTTYPE result) {
        this.result = result;
    }

    abstract void add(int var1, int var2, SentencePieceAlgorithm.SegmentEnd[] var3);

    RESULTTYPE result() {
        return this.result;
    }

    void build(String input, SentencePieceAlgorithm.SegmentEnd[] segmentEnds, boolean collapseUnknowns) {
        if (collapseUnknowns) {
            int segmentEnd;
            int collapsedSegmentEnd = segmentEnd = input.length();
            while (segmentEnd > 0) {
                if (segmentEnds[segmentEnd].type != TokenType.unknown) {
                    if (collapsedSegmentEnd != segmentEnd) {
                        this.add(segmentEnd, collapsedSegmentEnd, segmentEnds);
                    }
                    this.add(segmentEnds[segmentEnd].segmentStart, segmentEnd, segmentEnds);
                    collapsedSegmentEnd = segmentEnds[segmentEnd].segmentStart;
                }
                segmentEnd = segmentEnds[segmentEnd].segmentStart;
            }
        } else {
            int segmentEnd = input.length();
            while (segmentEnd > 0) {
                this.add(segmentEnds[segmentEnd].segmentStart, segmentEnd, segmentEnds);
                segmentEnd = segmentEnds[segmentEnd].segmentStart;
            }
        }
    }
}

