/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.sentencepiece;

import com.yahoo.io.IOUtils;
import com.yahoo.language.Language;
import com.yahoo.language.sentencepiece.TokenType;
import com.yahoo.language.sentencepiece.Trie;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import sentencepiece.SentencepieceModel;

final class Model {
    final Path source;
    final Language language;
    final float minScore;
    final float maxScore;
    final Trie tokens = new Trie();

    Model(Language language, Path path) {
        try {
            this.source = path;
            this.language = language;
            SentencepieceModel.ModelProto sp = SentencepieceModel.ModelProto.parseFrom(IOUtils.readFileBytes((File)path.toFile()));
            float minScore = Float.MAX_VALUE;
            float maxScore = Float.MIN_VALUE;
            for (int i = 0; i < sp.getPiecesCount(); ++i) {
                SentencepieceModel.ModelProto.SentencePiece piece = sp.getPieces(i);
                this.tokens.add(Model.toTokenType(piece.getType()), i, piece.getPiece(), piece.getScore());
                minScore = Math.min(piece.getScore(), minScore);
                maxScore = Math.max(piece.getScore(), maxScore);
            }
            this.minScore = minScore;
            this.maxScore = maxScore;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read a SentencePiece model from " + path, e);
        }
    }

    private static TokenType toTokenType(SentencepieceModel.ModelProto.SentencePiece.Type type) {
        switch (type) {
            case USER_DEFINED: {
                return TokenType.userDefined;
            }
            case UNKNOWN: {
                return TokenType.unknown;
            }
            case NORMAL: {
                return TokenType.text;
            }
            case CONTROL: {
                return TokenType.control;
            }
            case UNUSED: {
                return TokenType.unused;
            }
        }
        throw new IllegalArgumentException("Unknkown token type " + type);
    }

    public String toString() {
        return "SentencePiece model for " + this.language + ": '" + this.source + "'";
    }
}

