/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoSocket;
import com.yahoo.jrt.MaybeTlsCryptoEngine;
import com.yahoo.jrt.NullCryptoEngine;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.TlsCryptoEngine;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.nio.channels.SocketChannel;

public interface CryptoEngine
extends AutoCloseable {
    public CryptoSocket createClientCryptoSocket(SocketChannel var1, Spec var2);

    public CryptoSocket createServerCryptoSocket(SocketChannel var1);

    public static CryptoEngine createDefault() {
        if (!TransportSecurityUtils.isTransportSecurityEnabled()) {
            return new NullCryptoEngine();
        }
        TlsContext tlsContext = (TlsContext)TransportSecurityUtils.getSystemTlsContext().get();
        TlsCryptoEngine tlsCryptoEngine = new TlsCryptoEngine(tlsContext);
        MixedMode mixedMode = TransportSecurityUtils.getInsecureMixedMode();
        switch (mixedMode) {
            case DISABLED: {
                return tlsCryptoEngine;
            }
            case PLAINTEXT_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, false);
            }
            case TLS_CLIENT_MIXED_SERVER: {
                return new MaybeTlsCryptoEngine(tlsCryptoEngine, true);
            }
        }
        throw new IllegalArgumentException(mixedMode.toString());
    }

    @Override
    default public void close() {
    }
}

