/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import java.nio.ByteBuffer;

public class StringValue
extends Value {
    private Utf8Array value;

    public StringValue(String value) {
        this.value = new Utf8String(value);
    }

    public StringValue(Utf8String value) {
        this.value = value;
    }

    public StringValue(Utf8Array value) {
        this.value = value;
    }

    StringValue(ByteBuffer src) {
        int size = src.getInt();
        this.value = new Utf8String((AbstractUtf8Array)new Utf8Array(src, size));
    }

    @Override
    public byte type() {
        return 115;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    int bytes() {
        return 4 + this.value.getByteLength();
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.getByteLength());
        this.value.writeTo(dst);
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    @Override
    public Utf8Array asUtf8Array() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

